<?php

namespace App\Models;

use App\Traits\TracksCreationInfo;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CardMonthlyMaintenanceDeduction
 *
 * @property $id
 * @property $card_id
 * @property $user_id
 * @property $batch_id
 * @property $maintenance_fee
 * @property $exchange_rate
 * @property $deducted_amount
 * @property $deducted_from
 * @property $billing_date
 * @property $deduction_month
 * @property $deduction_year
 * @property $status
 * @property $remarks
 * @property $_id
 * @property $created_ip
 * @property $created_by
 * @property $updated_by
 * @property $created_agent
 * @property $updated_agent
 * @property $updated_ip
 * @property $created_at
 * @property $updated_at
 *
 * @property VirtualCard $virtualCard
 * @property User $user
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class CardMonthlyMaintenanceDeduction extends Model
{
use TracksCreationInfo;
    protected $perPage = 20;
protected $table='card_monthly_maintenance_deduction';
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['card_id', 'user_id', 'batch_id', 'maintenance_fee', 'exchange_rate', 'deducted_amount', 'deducted_from', 'billing_date', 'deduction_month', 'deduction_year', 'status', 'remarks', '_id', 'created_ip', 'created_by', 'updated_by', 'created_agent', 'updated_agent', 'updated_ip'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function virtualCard()
    {
        return $this->belongsTo(\App\Models\VirtualCard::class, 'card_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'user_id', 'id');
    }
    public function batchProcess()
    {
        return $this->belongsTo(\App\Models\CardMaintenanceCharge::class, 'batch_id', 'batch_id');
    }

}
