<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class CryptoTradingProfitTransaction
 *
 * @property $id
 * @property $user_id
 * @property $wallet_address
 * @property $virtual_account_id
 * @property $blockchain_code
 * @property $amount
 * @property $trading_ref
 * @property $descriptions
 * @property $transaction_type
 * @property $withdraw_amount
 * @property $withdraw_status
 * @property $created_at
 * @property $updated_at
 * @property $transaction_reference
 * @property $sender_va
 * @property $receiver_va
 * @property $account_type
 *
 * @property User $user
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class CryptoTradingProfitTransaction extends Model
{

    protected $perPage = 20;
protected $table = 'crypto_trading_profit_transaction';
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['user_id', 'wallet_address', 'virtual_account_id', 'blockchain_code', 'amount', 'trading_ref', 'descriptions', 'transaction_type', 'withdraw_amount', 'withdraw_status','transaction_reference'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'user_id', 'id');
    } /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function account()
    {
        return $this->belongsTo(\App\Models\VirtualAccounts::class, 'virtual_account_id', 'virtual_account_id');
    }

}
