<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class CryptoTransaction
 *
 * @property $id
 * @property $price_amount
 * @property $price_currency
 * @property $order_id
 * @property $pay_currency
 * @property $payout_currency
 * @property $sender_address
 * @property $transfer_type
 * @property $send_from
 * @property $send_to
 * @property $payment_id
 * @property $payment_status
 * @property $pay_amount
 * @property $amount_received
 * @property $order_description
 * @property $payin_extra_id
 * @property $ipn_callback_url
 * @property $server_created_at
 * @property $server_updated_at
 * @property $purchase_id
 * @property $network
 * @property $expiration_estimate_date
 * @property $is_fixed_rate
 * @property $is_fee_paid_by_user
 * @property $valid_until
 * @property $type
 * @property $payment_creation_status
 * @property $user_id
 * @property $rate
 * @property $converted_amount
 * @property $fund_wallet_status
 * @property $fund_wallet_status_at
 * @property $approved_wallet_funding_method
 * @property $approved_wallet_funding_at
 * @property $approved_wallet_funding_by
 * @property $created_at
 * @property $updated_at
 * @property $recieved_converted_amount
 * @property $price_in_usd
 * @property $outcome_amount
 * @property $outcome_currency
 * @property $actually_paid
 * @property $coin_confirm_status
 * @property $txid
 * @property $vin_crypto
 * @property $vout_crypto
 * @property $txt_fees
 * @property $vin_amount_usd
 * @property $vout_amount_usd
 * @property $refer_bonus
 * @property $referred_by
 * @property $refer_bonus_rate
 * @property $transaction_type
 * @property $payment_method
 * @property $coin_rate
 * @property $coin
 * @property $blockchain_code
 * @property $transaction_reference
 * @property $deducted_account
 * @property $payout_rate
 * @property $payout_amount
 * @property $deducted_asset_amount
 * @property $deducted_asset_amount_usd
 * @property $refer_bonus_payout_amount
 * @property $master_address
 * @property $token_address
 * @property $recipient_address
 * @property $gas_fees
 * @property $profit_on_gas
 * @property $payment_reference
 * @property $virtual_wallet_id
 * @property $coin_amount
 *
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class CryptoTransaction extends Model
{

    protected $perPage = 20;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['price_amount', 'price_currency', 'order_id', 'pay_currency', 'payout_currency', 'sender_address', 'transfer_type', 'send_from', 'send_to', 'payment_id', 'payment_status', 'pay_amount', 'amount_received', 'order_description', 'payin_extra_id', 'ipn_callback_url', 'server_created_at', 'server_updated_at', 'purchase_id', 'network', 'expiration_estimate_date', 'is_fixed_rate', 'is_fee_paid_by_user', 'valid_until', 'type', 'payment_creation_status', 'user_id', 'rate', 'converted_amount', 'fund_wallet_status', 'fund_wallet_status_at', 'approved_wallet_funding_method', 'approved_wallet_funding_at', 'approved_wallet_funding_by', 'recieved_converted_amount', 'price_in_usd', 'outcome_amount', 'outcome_currency', 'actually_paid', 'coin_confirm_status', 'txid', 'vin_crypto', 'vout_crypto', 'txt_fees', 'vin_amount_usd', 'vout_amount_usd', 'refer_bonus', 'referred_by', 'refer_bonus_rate', 'transaction_type', 'payment_method', 'coin_rate', 'coin', 'blockchain_code', 'transaction_reference', 'deducted_account', 'payout_rate', 'payout_amount', 'deducted_asset_amount', 'deducted_asset_amount_usd', 'refer_bonus_payout_amount', 'master_address', 'token_address', 'recipient_address', 'gas_fees', 'profit_on_gas', 'payment_reference', 'virtual_wallet_id', 'coin_amount'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'user_id', 'id');
    }

}
