<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class Merchant extends Authenticatable
{
    use HasFactory;
    protected static function booted()
    {
        static::creating(function ($model) {
            $model->access_key = Str::uuid();
        });


    }
    protected $fillable = [
        'business_name',
        'name',
        'email',
        'photo',
        'phone',
        'country',
        'city',
        'email_verified',
        'verification_link',
        'address',
        'status',
        'zip',
        'password',
    ];
    protected $casts = ['kyc_info'=>'array'];

    public function wallets()
    {
        return $this->hasMany(Wallet::class,'user_id')->where('user_type',2);
    }
    public function api()
    {
        return $this->hasOne(ApiCreds::class,'merchant_id');
    }


    public function getUserAccessKey($uid){
        return User::where('id',$uid)->pluck('access_key')->first();
    }
    public function getMerchantAccessKey($uid){
        return $this::where('id',$uid)->pluck('access_key')->first();
    }

    public function saveToClientWallet($amount,$user, $type){
        $getWallet =Wallet::where('user_id', $user)->first();
        if($type=='Pending') {
            $walletBalance = $getWallet->pending_balance;
            $getWallet->pending_balance = $walletBalance + $amount;
        }elseif($type=='Balance'){
            $walletBalance = $getWallet->balance;
            $getWallet->balance = $walletBalance + $amount;
        }elseif($type=='ReferPending'){
            $walletBalance = $getWallet->pending_refer_bonus;
            $getWallet->pending_refer_bonus = $walletBalance + $amount;
        }elseif($type=='Refer'){
            $walletBalance = $getWallet->refer_bonus_balance;
            $getWallet->refer_bonus_balance = $walletBalance + $amount;
        }
        $getWallet->save();

    }

}
