<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;


class TradeRequests extends Model
{
    use HasFactory;

// Model
    protected static function boot()
    {
        parent::boot();
        static::creating(function ($model) {
            $model->{$model->getKeyName()} = (string) Str::uuid();
        });
    }

    public function getIncrementing ()
    {
        return false;
    }

    public function getKeyType ()
    {
        return 'string';
    }

    public function requestedBy(){
        return $this->hasOne(User::class,'id','request_by');
    }
    public function merchantBy(){
        return $this->hasOne(Merchant::class,'id','send_to');
    }
    public function tradeDetail(){
        return $this->hasOne(TradeGiftCard::class,'id','trade_id');
    }

    public function tradeTransaction(){
        return $this->hasOne(TransactionHistory::class,'request_id','id');
    }


}
