<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Str;

class TradingCardDetails extends Model
{
    use HasFactory;

    protected static function booted()
    {
        static::creating(function ($model) {
            $model->_id = Str::uuid();
        });


    }

    public function cards(): BelongsTo
    {
        return $this->belongsTo(GiftCards::class, 'card_id', 'id');
    }
    public function trading(): BelongsTo
    {
        return $this->belongsTo(TradeGiftCard::class, 'trading_id', 'id');
    }

    public function transactionHistory(){
        return $this->belongsTo(TransactionHistory::class, 'id', 'tradedcard_details_id');
    }


}
