<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class TransactionHistory
 *
 * @property $id
 * @property $descriptions
 * @property $trade_id
 * @property $request_id
 * @property $tradedcard_details_id
 * @property $transaction_ref
 * @property $amount
 * @property $transaction_amount_in_usd
 * @property $exchange_rate
 * @property $user_id
 * @property $transaction_type
 * @property $created_by
 * @property $source
 * @property $status
 * @property $status_at
 * @property $status_by
 * @property $status_reason
 * @property $created_at
 * @property $updated_at
 * @property $refer_bonus
 * @property $referer_user_id
 * @property $rate
 * @property $currency
 *
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class TransactionHistory extends Model
{

    protected $perPage = 20;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['descriptions', 'trade_id', 'request_id', 'tradedcard_details_id', 'transaction_ref', 'amount', 'transaction_amount_in_usd', 'exchange_rate', 'user_id', 'transaction_type', 'created_by', 'source', 'status', 'status_at', 'status_by', 'status_reason', 'refer_bonus', 'referer_user_id', 'rate', 'currency'];

    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'user_id', 'id');
    }

}
