<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VirtualAccounts extends Model
{
    use HasFactory;

    public function coin(){
        return $this->hasOne(Coins::class, 'code','blockchain_code');
    }

    public function owner(){
        return $this->hasOne(User::class, 'id','user_id');
    }

    public function blockchain(){
        return $this->hasOne(BlockchainWallet::class,'blockchain_code','blockchain_code');
    }
}
