<?php

namespace App\Models;

use App\Traits\TracksCreationInfo;
use Illuminate\Database\Eloquent\Model;

/**
 * Class VirtualCard
 *
 * @property $id
 * @property $user_id
 * @property $account_id
 * @property $card_id
 * @property $currency
 * @property $holdertype
 * @property $cardbrand
 * @property $customerid
 * @property $card_balance
 * @property $available_bal
 * @property $first_name
 * @property $last_name
 * @property $date_of_birth
 * @property $email
 * @property $card_icon
 * @property $phone
 * @property $title
 * @property $gender
 * @property $billing_name
 * @property $billing_address
 * @property $billing_city
 * @property $billing_state
 * @property $billing_postal_code
 * @property $address_1
 * @property $billing_country
 * @property $callback_url
 * @property $card_number
 * @property $masked_pan
 * @property $cvv
 * @property $expiry_date
 * @property $card_type
 * @property $status
 * @property $is_active
 * @property $created_at
 * @property $updated_at
 * @property $_id
 * @property $created_ip
 * @property $created_agent
 * @property $updated_agent
 * @property $updated_ip
 *
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class VirtualCard extends Model
{
    use TracksCreationInfo;
    protected $perPage = 20;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['user_id', 'account_id', 'card_id', 'currency', 'holdertype', 'cardbrand', 'customerid', 'card_balance', 'available_bal', 'first_name', 'last_name', 'date_of_birth', 'email', 'card_icon', 'phone', 'title', 'gender', 'billing_name', 'billing_address', 'billing_city', 'billing_state', 'billing_postal_code', 'address_1', 'billing_country', 'callback_url', 'card_number', 'masked_pan', 'cvv', 'expiry_date', 'card_type', 'status', 'is_active', '_id', 'created_ip','created_agent','updated-ip','updated_agent'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'user_id', 'id');
    }
}
