<?php

namespace App\Models;

use App\Traits\TracksCreationInfo;
use Illuminate\Database\Eloquent\Model;

/**
 * Class VirtualCardKy
 *
 * @property $id
 * @property $user_id
 * @property $status
 * @property $bvn
 * @property $nin_no
 * @property $house_no
 * @property $street
 * @property $city
 * @property $state
 * @property $country
 * @property $postal_code
 * @property $id_type
 * @property $id_number
 * @property $id_image_url
 * @property $address
 * @property $phone_number
 * @property $created_at
 * @property $updated_at
 * @property $updated_ip
 * @property $updated_by
 * @property $photo
 * @property $status_updated_at
 * @property $status_updated_by
 * @property $_id
 * @property $updated_agent
 * @property $created_ip
 * @property $created_agent
 *
 * @property User $user
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class VirtualCardKy extends Model
{

    protected $perPage = 20;
    use TracksCreationInfo;
    protected $table="virtual_card_kys";

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['user_id', 'status', 'bvn', 'nin_no',
        'house_no', 'street', 'city', 'state', 'country', 'postal_code',
        'id_type', 'id_number', 'id_image_url', 'address', 'phone_number', 'updated_ip','updated_agent','created_ip','created_agent','status_updated_at'
    ,'status_updated_by','note_on_status','photo'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'user_id', 'id');
    }

}
