<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class VirtualCardsSetting
 *
 * @property $id
 * @property $issuing_fee
 * @property $minimum_funding
 * @property $monthly_maintenance_fee
 * @property $withdrawal_fee
 * @property $decline_fee
 * @property $cross_border_percentage
 * @property $cross_border_fixed_fee
 * @property $exchange_rate
 * @property $referer_bonus
 * @property $created_at
 * @property $updated_at
 *
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class VirtualCardsSetting extends Model
{
    
    protected $perPage = 20;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['issuing_fee', 'minimum_funding', 'monthly_maintenance_fee', 'withdrawal_fee', 'decline_fee', 'cross_border_percentage', 'cross_border_fixed_fee', 'exchange_rate', 'referer_bonus'];


}
