<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class VirtualcardCustomer
 *
 * @property $id
 * @property $user_id
 * @property $first_name
 * @property $last_name
 * @property $phone_number
 * @property $bvnno
 * @property $email_address
 * @property $house_no
 * @property $street
 * @property $city
 * @property $state
 * @property $country
 * @property $postal_code
 * @property $idtype
 * @property $idno
 * @property $idurl
 * @property $trackid
 * @property $issuance_country
 * @property $created_at
 * @property $updated_at
 *
 *
 * @property User $user
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class VirtualcardCustomer extends Model
{

    protected $perPage = 20;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['user_id', 'first_name', 'last_name','trackid', 'phone_number', 'bvnno', 'email_address', 'house_no', 'street', 'city', 'state', 'country', 'postal_code', 'idtype', 'idno', 'idurl', 'issuance_country'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'user_id', 'id');
    }

}
