<?php

namespace App\Traits;

use Illuminate\Support\Facades\Request;
use Illuminate\Support\Str;

trait TracksCreationInfo
{
    /**
     * Boot the trait.
     */
    public static function bootTracksCreationInfo()
    {
        static::creating(function ($model) {
            // Generate a UUID for the _id field if it's not already set
            if (empty($model->_id)) {
                $model->_id = Str::uuid()->toString();
            }
            $model->created_ip = Request::ip();
            $model->created_agent = Request::header('User-Agent');
        });
        static::updating(function ($model) {
            $model->updated_ip = Request::ip();
            $model->updated_agent = Request::header('User-Agent');
        });
    }
}
