<?php

use App\Http\Controllers\PusherAuthController;
use App\Http\Controllers\SupportTicketController;
use App\Http\Controllers\User\AuthController;
use App\Http\Controllers\User\AuthorizationController;
use App\Http\Controllers\User\BeneficiaryController;
use App\Http\Controllers\User\BillController;
use App\Http\Controllers\User\CryptoController;
use App\Http\Controllers\User\DepositController;
use App\Http\Controllers\User\EscrowController;
use App\Http\Controllers\User\ExchangeMoneyController;
use App\Http\Controllers\User\MakePaymentController;
use App\Http\Controllers\User\ManageInvoiceController;
use App\Http\Controllers\User\RequestMoneyController;
use App\Http\Controllers\User\ShoppingController;
use App\Http\Controllers\User\TradeGiftController;
use App\Http\Controllers\User\TransferController;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\User\VirtualCardController;
use App\Http\Controllers\User\VoucherController;
use App\Http\Controllers\User\WithdrawalController;
use App\Http\Controllers\VirtualCardKyController;
use Illuminate\Support\Facades\Route;

Route::prefix('user')->name('user.')->middleware('maintenance')->group(function () {
    Route::get('register/{ref?}',  [AuthController::class,'registerForm'])->name('register');
    Route::post('register/{ref?}',  [AuthController::class,'register'])->name('saveregister');
    Route::get('login',     [AuthController::class,'showLoginForm'])->name('login');
    Route::post('login',    [AuthController::class,'login'])->name('login');
    Route::get('logout',     [AuthController::class,'logout'])->name('logout');
    Route::get('forgot-password',     [AuthController::class,'forgotPassword'])->name('forgot.password');
    Route::post('forgot-password',     [AuthController::class,'forgotPasswordSubmit']);
    Route::get('forgot-password/verify-code',     [AuthController::class,'verifyCode'])->name('verify.code');
    Route::post('forgot-password/verify-code',     [AuthController::class,'verifyCodeSubmit']);

    Route::get('reset-password',     [AuthController::class,'resetPassword'])->name('reset.password');
    Route::post('reset-password',     [AuthController::class,'resetPasswordSubmit']);

    Route::get('verify-email',     [AuthorizationController::class,'verifyEmail'])->name('verify.email')->middleware('auth');
    Route::post('verify-email',     [AuthorizationController::class,'verifyEmailSubmit'])->middleware('auth');
    Route::get('resend/verify-email/code',     [AuthorizationController::class,'verifyEmailResendCode'])->name('verify.email.resend')->middleware('auth');


    Route::get('two-step/verification',     [AuthorizationController::class,'twoStep'])->name('two.step.verification')->middleware('auth');

    Route::post('two-step/verification',     [AuthorizationController::class,'twoStepVerify'])->middleware('auth');

    Route::get('resend/two-step/verify-code', [AuthorizationController::class,'twoStepResendCode'])->name('two.step.resend')->middleware('auth');

    Route::middleware(['auth','email_verify','twostep'])->group(function () {
        Route::get('/', [UserController::class,'index'])->name('dashboard');
        Route::get('profile',   [UserController::class,'profile'])->name('profile');
        Route::post('profile',  [UserController::class,'profileSubmit']);
        Route::post('change-password',  [UserController::class,'changePass'])->name('change.pass');
        Route::post('check-receiver', [TransferController::class,'checkReceiver'])->name('check.receiver');
        Route::post('check-merchant', [MakePaymentController::class,'checkMerchant'])->name('check.merchant');
        Route::post('check-agent', [WithdrawalController::class,'checkAgent'])->name('check.agent');
        Route::get('transactions', [UserController::class,'transactions'])->name('transactions');
        Route::get('transaction/details/{id}', [UserController::class,'trxDetails'])->name('trx.details');
        Route::get('testcard', [BillController::class,'testCard'])->name('test.card');

        //off module
        Route::get('module/{module}',   [UserController::class,'moduleOff'])->name('module.off');

        Route::middleware(['module','kyc'])->group(function () {

            //transfer-money
            Route::get('transfer-money',  [TransferController::class,'transferForm'])->name('transfer.money');
            Route::post('transfer-money', [TransferController::class,'submitTransfer']);

            //Request Money
            Route::get('request-money',  [RequestMoneyController::class,'requestForm'])->name('request.money');
            Route::post('request-money', [RequestMoneyController::class,'requestSubmit']);

            //exchange money
            Route::get('exchange-money',   [ExchangeMoneyController::class,'exchangeForm'])->name('exchange.money');
            Route::post('exchange-money',  [ExchangeMoneyController::class,'submitExchange']);

            // merchant payment
            Route::get('make-payment',   [MakePaymentController::class,'paymentForm'])->name('make.payment');
            Route::post('make-payment',  [MakePaymentController::class,'submitPayment']);

            //voucher
            Route::get('create-voucher',   [VoucherController::class,'create'])->name('create.voucher');
            Route::post('create-voucher',   [VoucherController::class,'submit']);

            //withdraw


            //invoice
            Route::get('create-invoice',   [ManageInvoiceController::class,'create'])->name('invoice.create');
            Route::post('create-invoice',   [ManageInvoiceController::class,'store']);

            //escrow
            Route::get('make-escrow',   [EscrowController::class,'create'])->name('escrow.create');
            Route::post('make-escrow',   [EscrowController::class,'store']);

            //deposit
            Route::get('deposit',[DepositController::class,'index'])->name('deposit.index');

            //beneficiary


        });
        Route::get('withdraw-money',    [WithdrawalController::class,'withdrawForm'])->name('withdraw.form');
        Route::post('withdraw-confirm',   [WithdrawalController::class,'withdrawSubmit'])->name('withdraw.confirm');
//virtual card
        Route::get('/virtual-cards/index',[VirtualCardController::class,'index'])->name('virtual-cards.mycards');
        Route::get('/virtual-cards/create',[VirtualCardController::class,'create'])->name('virtual-cards.create');
        Route::post('/virtual-cards/store',[VirtualCardController::class,'store'])->name('virtual-cards.store');
//virtual card kyc
        //Route::get('/virtual-cards/index',[VirtualCardKyController::class,'index'])->name('card.kyc-list');
        Route::get('/virtual-cards/kyc/create',[VirtualCardKyController::class,'create'])->name('virtual-card-kyc.create');
        Route::post('/virtual-cards/kyc/store',[VirtualCardKyController::class,'store'])->name('virtual-card-kyc.store');
  Route::get('/virtual-cards/kyc/edit',[VirtualCardKyController::class,'edit'])->name('virtual-card-kyc.edit');
  Route::post('/virtual-cards/kyc/update',[VirtualCardKyController::class,'update'])->name('virtual-card-kyc.update');
        Route::post('/virtual-cards/kyc/store',[VirtualCardKyController::class,'store'])->name('virtual-card-kyc.store');

        //transfer-money
        Route::get('transfer-money/history',  [TransferController::class,'transferHistory'])->name('transfer.history');

        //exchange money
        Route::get('exchange-money/history',  [ExchangeMoneyController::class,'exchangeHistory'])->name('exchange.history');

        //payment history
        Route::get('payment/history',  [MakePaymentController::class,'paymentHistory'])->name('payment.history');

        //Request Money
        Route::get('money-request',  [RequestMoneyController::class,'moneyRequests'])->name('money.requests');
        Route::get('sent-requests',  [RequestMoneyController::class,'moneyRequests'])->name('sent.requests');
        Route::get('received-requests', [RequestMoneyController::class,'moneyRequests'])->name('received.requests');
        Route::post('accept-request', [RequestMoneyController::class,'acceptRequest'])->name('accept.request');
        Route::post('reject-request', [RequestMoneyController::class,'rejectRequest'])->name('reject.request');

        //Reedem voucher
        Route::get('vouchers',  [VoucherController::class,'vouchers'])->name('vouchers');
        Route::get('reedem-voucher',  [VoucherController::class,'reedemForm'])->name('reedem.voucher');
        Route::post('reedem-voucher',  [VoucherController::class,'reedemSubmit']);
        Route::get('reedemed-history',  [VoucherController::class,'reedemHistory'])->name('reedem.history');

        //withdraw
        Route::get('withdraw-methods',  [WithdrawalController::class,'methods'])->name('withdraw.methods');
        Route::get('withdraw-history',  [WithdrawalController::class,'history'])->name('withdraw.history');

        //invoice
        Route::get('invoices',   [ManageInvoiceController::class,'index'])->name('invoice.index');
        Route::post('invoice/pay-status',   [ManageInvoiceController::class,'payStatus'])->name('invoice.pay.status');
        Route::post('invoice/publish-status',   [ManageInvoiceController::class,'publishStatus'])->name('invoice.publish.status');

        Route::get('invoices-edit/{id}',   [ManageInvoiceController::class,'edit'])->name('invoice.edit');
        Route::post('invoices-update/{id}',   [ManageInvoiceController::class,'update'])->name('invoice.update');
        Route::get('invoice-cancel/{id}',   [ManageInvoiceController::class,'cancel'])->name('invoice.cancel');
        Route::get('invoice/send-mail/{id}',   [ManageInvoiceController::class,'sendToMail'])->name('invoice.send.mail');
        Route::get('invoice/view/{number}',   [ManageInvoiceController::class,'view'])->name('invoice.view');

        Route::get('invoices-payment/{number}',   [ManageInvoiceController::class,'invoicePayment'])->name('invoice.payment');
        Route::post('invoices-payment/{number}',   [ManageInvoiceController::class,'invoicePaymentSubmit']);
        Route::get('pay-invoice',   [DepositController::class,'invoicePayment'])->name('pay.invoice');


        //escrow
        Route::get('my-escrow',   [EscrowController::class,'index'])->name('escrow.index');
        Route::get('escrow-pending',   [EscrowController::class,'pending'])->name('escrow.pending');
        Route::get('escrow-dispute/{id}',   [EscrowController::class,'disputeForm'])->name('escrow.dispute');
        Route::post('escrow-dispute/{id}',   [EscrowController::class,'disputeStore']);
        Route::get('release-escrow/{id}',   [EscrowController::class,'release'])->name('escrow.release');
        Route::get('file-download/{id}',   [EscrowController::class,'fileDownload'])->name('escrow.file.download');

        //kyc form
        Route::get('kyc-form',   [UserController::class,'kycForm'])->name('kyc.form');
        Route::post('kyc-form',   [UserController::class,'kycFormSubmit']);


        Route::get('/generate-qrcode', [UserController::class,'generateQR'])->name('qr');

        //deposit
        Route::post('payment/submit',[DepositController::class,'depositSubmit'])->name('deposit.submit');
        Route::post('payment-submit',[DepositController::class,'depositPayment'])->name('deposit.payment');
        Route::get('deposit/history',[DepositController::class,'dipositHistory'])->name('deposit.history');
        Route::get('deposit/crypto',[DepositController::class,'depositcrypto'])->name('depositcrypto');
        Route::get('deposit/fiat',[DepositController::class,'depositfiat'])->name('depositfiat');
        Route::get('gateway-methods',  [DepositController::class,'methods'])->name('gateway.methods');
        Route::get('finalize-payment/{data}',  [DepositController::class,'finalize'])->name('payment.finalize');

        //twostep
        Route::get('/two-step/authentication', [UserController::class,'twoStep'])->name('two.step');
        Route::get('/two-step/verify', [UserController::class,'twoStepVerifyForm'])->name('two.step.verify');
        Route::post('/two-step/verify', [UserController::class,'twoStepVerifySubmit']);
        Route::post('/two-step/authentication', [UserController::class,'twoStepSendCode']);

        Route::get('download-qr/{email}',  [UserController::class,'downloadQR'])->name('download.qr');

        // support ticket
      //  Route::get('support/tickets',   [SupportTicketController::class,'index'])->name('ticket.index');
       // Route::post('open/support/tickets',   [SupportTicketController::class,'openTicket'])->name('ticket.open');
      //  Route::post('tickets/create', [SupportTicketController)->name('post.ticket');
     //   Route::post('reply/ticket/{ticket_num}',   [SupportTicketController::class,'replyTicket'])->name('ticket.reply');
        //this where my route started
        Route::get('giftcard/sell-giftcard',[TradeGiftController::class, 'SellGiftCard'])->name('sell-giftcard');
        Route::get('giftcard/get-amount/{gid}',[TradeGiftController::class, 'getGiftCardAmount'])->name('get-amount');
        Route::get('giftcard/get-rate/{ref}',[TradeGiftController::class, 'getRate'])->name('get-rate');
        Route::post('giftcard/save-trade',[TradeGiftController::class, 'saveTrade'])->name('save-trade');
        //trading start here
        Route::get('giftcard/trade/trading/{id}',[TradeGiftController::class, 'trading'])->name('giftcard.start-trade');
        Route::get('giftcard/trade',[TradeGiftController::class, 'tradeChat'])->name('giftcard.trading');
        Route::get('giftcard/merchant/{reference}',[TradeGiftController::class, 'listMerchant'])->name('merchant');
        Route::post('giftcard/send-trade-request',[TradeGiftController::class, 'sendTradeRequest'])->name('giftcard.sendtradereqeust');
        Route::get('giftcard/trade/getTrades',[TradeGiftController::class,'getTradingList'])->name('get-trading-list');
        Route::post('giftcard/trade/requestInfo',[TradeGiftController::class, 'tradeRequestDetails'])->name('get-trade-request');
        /**
         * Fetch messages
         */
        Route::post('giftcard/trade/fetchTradingConversation', [TradeGiftController::class,'fetchTradingConversation'])->name('fetch.tradingmessage');
        Route::post('giftcard/trade/shared',[TradeGiftController::class, 'sharedPhotos'])->name('shared-photo');
        /**
         * Send message route
         */
        Route::post('giftcard/trade/sendMessage', [TradeGiftController::class,'sendMessage'])->name('send.message');
        Route::post('giftcard/trade/updateContacts', [TradeGiftController::class,'updateTradeList'])->name('update-contact');

        /**
         * Make messages as seen
         */
        Route::post('giftcard/trade/makeSeen', [TradeGiftController::class,'seen'])->name('messages.seen');

//shoping
        Route::get('/shopping',[ShoppingController::class, 'index'])->name('shopping-index');
        Route::get('/shopping/product/{slug}',[ShoppingController::class, 'productDetails'])->name('shopping-product-details');


        Route::post('/pusher/auth', [PusherAuthController::class,'userAuth'])->name('userpusher.auth');


        /**
         * Download attachments route to create a downloadable links
         */
        Route::get('/download/{fileName}', [TradeGiftController::class,'download'])->name(config('chatify.attachments.download_route_name'));
        Route::post('giftcard/trade/setActiveStatus', [TradeGiftController::class,'setActiveStatus'])->name('user.setActive');
        Route::get('giftcard/my-trades', [TradeGiftController::class,'myTrades'])->name('my-trade');
        Route::get('giftcard/transactions', [TradeGiftController::class,'tradeTransactions'])->name('trade-transactions');
        Route::get('/beneficiary', [BeneficiaryController::class,'index'])->name('beneficiary-index');

       // Route::get('test-w',[WithdrawalController::class,'testFlutter']);

        Route::post('resolve-account',[BeneficiaryController::class,'resolveAccount'])->name('bank.resolveaccount');
        Route::post('/beneficiary/add',[BeneficiaryController::class,'saveBeneficiary'])->name('beneficiary.save');
        Route::get('/bill',[BillController::class,'index']);
        Route::get('bill-history',  [BillController::class,'history'])->name('bill.history');

        Route::get('/crypto/trade-test',[CryptoController::class,'tradeCryptoTest'])->name('crypto.tradetest');
        Route::get('/crypto/sell',[CryptoController::class,'tradeCrypto'])->name('crypto.sell');
        Route::get('/crypto/buy',[CryptoController::class,'buyCrypto'])->name('crypto.buy');
        Route::post('/crypto/confirm-buy',[CryptoController::class,'confirmPreview'])->name('crypto.confirm-buy');
        Route::post('/crypto/confirm-order',[CryptoController::class,'confirmBuy'])->name('crypto.confirm-order');
        Route::post('/crypto/confirm-wallet',[CryptoController::class,'confirmOrderByWallet'])->name('crypto.confirm-orderbywallet');
        Route::post('/crypto/confirm-card',[CryptoController::class,'confirmOrderByCard'])->name('crypto.confirm-orderbycard');
        Route::get('/crypto/payment-confirmed/{id}',[CryptoController::class,'paymentConfirmed'])->name('crypto.confirm-payment');
        Route::get('/crypto/get-rate/{id}',[CryptoController::class,'getEstimated'])->name('crypto.rate');
        Route::post('/crypto/trade',[CryptoController::class,'initTrade'])->name('crypto.trade');
        Route::get('/crypto/track-payment/{id}',[CryptoController::class,'trackPayment'])->name('crypto.track-payment');
        Route::get('/crypto/view-trade/{id}',[CryptoController::class,'viewTrade'])->name('crypto.view-payment');
        Route::get('/crypto/test-track',[CryptoController::class,'testConfirm'])->name('crypto.track-test');
        Route::get('/crypto/test-coin',[CryptoController::class,'testCoinpayment'])->name('crypto.test-coinpayment');
        Route::post('/crypto/confirm-trade',[CryptoController::class,'confirmPayment'])->name('crypto.confirm');
        Route::get('/crypto/cardpayment-callback',[CryptoController::class,'cardPaymentcallback'])->name('crypto.card-callback');
//this is for test
        Route::get('/crypto/testtatum',[CryptoController::class,'testTatum'])->name('crypto.test-tatum');
        Route::post('/crypto/create-asset',[CryptoController::class,'createWallet'])->name('crypto.createwallet');



        Route::post('/save-rf',[UserController::class,'saveReferCode'])->name('save.rf');
      //  Route::get('test-account',[UserController::class,'createDepositAccount']);
        Route::get('wallet',[UserController::class,'wallet'])->name('wallet');
        Route::get('bill/airtime',[BillController::class,'buyAirtime'])->name('buy-airtime');
        Route::get('bill/data',[BillController::class,'buyData'])->name('buy-data');
        Route::get('bill/cable',[BillController::class,'buyCable'])->name('buy-cable');
        Route::get('bill/test-data',[BillController::class,'updateData'])->name('test-data');
        Route::post('bill/get-databundle',[BillController::class,'getDataBundle'])->name('get-databundle');
        Route::post('bill/get-tvsub',[BillController::class,'getTVSub'])->name('get-tvsub');
        Route::post('bill/verify-icu',[BillController::class,'verifyICU'])->name('cable.verify-icu');
        Route::post('bill/confirm-airtime',   [BillController::class,'buyAirtimeConfirm'])->name('airtime.confirm');
        Route::post('bill/confirm-data',   [BillController::class,'buyDataConfirm'])->name('data.confirm');
        Route::post('bill/confirm-cable',   [BillController::class,'buyCableConfirm'])->name('cable.confirm');
        Route::get('bill/pay-electricity',   [BillController::class,'buyElectricity'])->name('electricity.buy');
        Route::post('bill/verify-meterno',[BillController::class,'verifyMeterNo'])->name('electricity.verify-meterno');
        Route::post('bill/confirm-electricity',   [BillController::class,'buyElectricityConfirm'])->name('electricity.confirm');
         Route::get('earning',   [UserController::class,'referbonusList'])->name('referbonus.list');
         Route::get('/inbox',   [UserController::class,'inbox'])->name('messages.inbox');
         Route::get('/view-inbox/{id}',   [UserController::class,'inboxview'])->name('messages.inbox-view');
         Route::post('/delete-inbox/{id}',   [UserController::class,'inboxdelete'])->name('messages.inbox-delete');
         Route::get('/tickets',   [UserController::class,'tickets'])->name('tickets');
         Route::get('/create-ticket',   [UserController::class,'createTicket'])->name('tickets.create');
         Route::post('/post-ticket',   [UserController::class,'postticket'])->name('post.ticket');
         Route::post('/reply-ticket',   [UserController::class,'postticket'])->name('post.reply-ticket');
         Route::get('/view-ticket/{id}',   [UserController::class,'ticketview'])->name('ticket-view');
         Route::get('/testdata',   [BillController::class,'dataPlan'])->name('testdata');


        Route::get('/crypto/withdraw/{asset}',[CryptoController::class,'withdrawAsset'])->name('crypto.withdraw-asset');
        Route::post('/crypto/withdraw/{asset}',[CryptoController::class,'withdrawAsset'])->name('crypto.post-withdraw-asset');

    });

});
Route::get('deposit-init',   [DepositController::class,'paymentInit'])->name('payment-init');

