<?php

/**
 *
 * @author Jan Moritz Lindemann
 */

namespace BitcoinPHP\BitcoinECDSA;


class BitcoinECDSATest extends \PHPUnit\Framework\TestCase
{
    private $expectedResultsJson = '[{"privKey":"b7a5e63a5da3df5c04b5be15734733205a45b751259f46d89471d4a8cd120929","compressedPubKey":"03a10b6eee47ad4382915d387ee7e17ed7bd22caa9771288df24560e7a5faad880","compressedAddr":"1FgSaVjai4mZ8hznWxjU5rNYKE22VViVKY","unCompressedPubKey":"04a10b6eee47ad4382915d387ee7e17ed7bd22caa9771288df24560e7a5faad880d3453509bfb0bb4cab044af6fe6efd0b52442199536fd4f513dfe2c40d0758db","unCompressedAddr":"1LTu7f38zuw3Yw4rCnw6dZzKvd5GyucG2z"},{"privKey":"febfa5160998f4d4e19df71a0944717de680393cf15ef83a7c8a9978215463e6","compressedPubKey":"02e3224530e8458f4950c73cc334c56ed6cc55e017298892369c87433e67166f50","compressedAddr":"17tuhHY7FdtTxYYPGxwyd8Z8oJmz7bEjWr","unCompressedPubKey":"04e3224530e8458f4950c73cc334c56ed6cc55e017298892369c87433e67166f50961b3b9035880d1747a42257aa00604f56bd6c4c82fa8cf558d3a1718c0247d2","unCompressedAddr":"1555ZmshtkvNYuZpWcNi26A2JC48mXm2ue"},{"privKey":"bb7e6982a84c144ea49522f05a779d34967d532175e076ced19e48de76ebc448","compressedPubKey":"02221f14c602ef7f5af71ac2999c88dcab54a9dbb205f36d3544f01b01c15f7438","compressedAddr":"12mWsjp2qbGyTLCZGySfJdkpehSQbdSsAy","unCompressedPubKey":"04221f14c602ef7f5af71ac2999c88dcab54a9dbb205f36d3544f01b01c15f743891b9f72e2a4e8908c2dc407ab29a5900e762f341e1321999dad8a0876e6159d2","unCompressedAddr":"1K8u4i8Z51UziUejYPRp4WiU7WKzoSA5NE"},{"privKey":"f81a0c9868860730d259e1d42416435294e3ca62a9e7ff32b2d20d9cc16ded0c","compressedPubKey":"0245f906f25b6bd378ec4c4b40a69cb2cfb509d3fdcbba5f3c09ea61ea50754ce0","compressedAddr":"17pCTv1Zv9JaFZS7dFiGKMFRpYGvQzzNSR","unCompressedPubKey":"0445f906f25b6bd378ec4c4b40a69cb2cfb509d3fdcbba5f3c09ea61ea50754ce0657b91af6cc02c98b0ae593360b2e51e553644f8c4c466851eff9fd597e5c66a","unCompressedAddr":"158znRo6E3fz2Ke7TNgJ3ZtD72D3czV7rc"},{"privKey":"98ff60624a8ac01bb28f0551cc673200dba10b74043398ea5f2bc1967bf793be","compressedPubKey":"022f33f1262bb31a50e13ce2881fec7adfbb45a5e2c6be6bf6b1f1df58090a6e96","compressedAddr":"17zCpTQBvwipyw43YGiLb7znjJqL62zGr5","unCompressedPubKey":"042f33f1262bb31a50e13ce2881fec7adfbb45a5e2c6be6bf6b1f1df58090a6e96f233c5b4900c9ec6864502a63b9b5f815e5434381e8d4908aba1f6a2a90b8082","unCompressedAddr":"19btb7RUEX9F2JHBxCNzz2B98XQoz9N4Ru"},{"privKey":"9987c4b07c756706ff0ad30e3ba84d8cdc18fcde22d8988d26bd3e7551b0cfbb","compressedPubKey":"031465f628f28aaeab832a2723d9b2921989ba446cde02293bb2ec02b651cc90b2","compressedAddr":"17kYib2s2U8CH4iUQEbt77YdA35cbsLZcW","unCompressedPubKey":"041465f628f28aaeab832a2723d9b2921989ba446cde02293bb2ec02b651cc90b217e2babcbca81c5122c24cb4226cd6d349d2023e3bcae0ab598d7db19b3e5695","unCompressedAddr":"1C1e8KVLt4oVt7E6LnuCyQByDvXHRz3F2H"},{"privKey":"20d88c3ef0fdaf25a85296b2ce2647b9510c15792413e2e44ff1da15abeefea6","compressedPubKey":"03a264a7ddd4f0f0b605aa60c43bbf26b516fe1dbfbce2529975a234de5e5ad261","compressedAddr":"17gyihFbNLmzQqDZvAbZoSt1yekoauGzKa","unCompressedPubKey":"04a264a7ddd4f0f0b605aa60c43bbf26b516fe1dbfbce2529975a234de5e5ad261fe12eaf3aca96127527ff8a8a2ce55036a1d5313b50b14eded35d9ef083c1d99","unCompressedAddr":"13zBAWzY6tUoN38qv82dN9N8dJPS5UrFNC"},{"privKey":"b26d53f3d8afd69dc9a26f2e4aea0917f1d994f320fb9ab37700e41d7c5ef060","compressedPubKey":"021836603b11843d2fe1017c9b0053dc23ea1cf560c33ce1289f9d62f735531e4c","compressedAddr":"19VtHtpPCdWePTtmtnn5Mx8mT93P1Ehwj","unCompressedPubKey":"041836603b11843d2fe1017c9b0053dc23ea1cf560c33ce1289f9d62f735531e4c80e7f89d44f7c082f3bea521d8fe9da17cea18cbb0f850fe7b3dbe7bed0c6a62","unCompressedAddr":"14oxmaPKiVSWNeBpVQ7Sp22YTLkidqRZAo"},{"privKey":"2b7fd8d06cbabb9ff9f232f5c6e37e7eae725b00e00e4e4339db4a426a0dbd40","compressedPubKey":"03d02cf99a672040d09a6eb7a3c51eff4c71beaeb9bbfb21ffe537eca6413b390a","compressedAddr":"16NgAAMfnchnEgEFF3BrFwGsRvHmmqimCH","unCompressedPubKey":"04d02cf99a672040d09a6eb7a3c51eff4c71beaeb9bbfb21ffe537eca6413b390a840f63d8fe7d7236dd63801e6765b4f38c0338203e18860d84697475c7ec7219","unCompressedAddr":"12PYkQhd9wmvGrHDdErr52Cw1VQQP4si8W"},{"privKey":"6efdee4246644bb2a5278d2b0e5d3c2972e729bf4dab515475e75202aad23ab5","compressedPubKey":"03a0bfcea3e9e9e501ac07b737c0659a52c0bcb7f30ccc034c787e642780e9968a","compressedAddr":"1Gxy8qxaCBc4bF6KwMTTQ7BBVzYtpJVD6y","unCompressedPubKey":"04a0bfcea3e9e9e501ac07b737c0659a52c0bcb7f30ccc034c787e642780e9968a9d850b7103fdbf3fcb224680012f68637b9bb2bf5492fec9e01a44c79f4f9143","unCompressedAddr":"1MmykoF7sW4pQ9m1VsAEWCNJdmSiSdU56E"},{"privKey":"1c632eb879da8deaa74765f81376f70a8996db72ab3998051239045860bb3e91","compressedPubKey":"022a678829aeac008f5b4572bcd8366c78fd49580000a2c4743894dc5f74d2d3a6","compressedAddr":"1JmJsoaMVNq3Sn2rdCX2AHvycWbTtA3BKV","unCompressedPubKey":"042a678829aeac008f5b4572bcd8366c78fd49580000a2c4743894dc5f74d2d3a6cb0e41f48f273b79aa1260c360bd35a94dfc8a27696555b108955afff303115c","unCompressedAddr":"1L9eFV8H7HA5Rs31x2yHTsedMQm5g37nqo"},{"privKey":"78d1af3e125ea7159a338834d886709e3d2c455fb6942a029d2adb7e253437d0","compressedPubKey":"025a54d86d1c6c018d3063d0fb8879d4eb3c9643c9fcd3a5d0e79fa90e5bc3f609","compressedAddr":"13Sh3pXieSSpBhueu1D2bW9pRdyf3qE5NZ","unCompressedPubKey":"045a54d86d1c6c018d3063d0fb8879d4eb3c9643c9fcd3a5d0e79fa90e5bc3f6092d2fa09ef5d152c46b76423b8b4ff8a20e44cf9b0216c1d3f95bc4209ab2f794","unCompressedAddr":"1BBv8sY5aygtg2UXcWUP3B8TzwwVycb7ZN"},{"privKey":"8a2ca34255e3ef25e8321e0625cc45a58650e7d7bbe48144240135dd12eed974","compressedPubKey":"0295ece1f03784eced867d0e814444eaf4bb9899dce675c1a03e6b2395a975f25c","compressedAddr":"1JuisCTiPMotBE16rNu25m4KiRvtTGAq6y","unCompressedPubKey":"0495ece1f03784eced867d0e814444eaf4bb9899dce675c1a03e6b2395a975f25cb37a990e11b81e72ca508b50a0cf5c803df3cc02fba6223ef6fb5b2b15158d56","unCompressedAddr":"1AgADx7zmrgAfH9q9qeqLSUsUzeEaQtkPH"},{"privKey":"8dcba7b9533d1ba28b6d333496a88959d923efc86e47930bf0e2b7db4bf8349c","compressedPubKey":"03a6e5e8b34dec4be6a67059c9a9965e6549a54217a54b9f563baab6db53e39ce8","compressedAddr":"1Q3anueZ5uZGK8rrnZX41uMfpoCH3K95cx","unCompressedPubKey":"04a6e5e8b34dec4be6a67059c9a9965e6549a54217a54b9f563baab6db53e39ce8cfd0906325dd15466d1d775d1be48d4f65de27f84f91463fe2cad01834506489","unCompressedAddr":"1PubPTiBhVxzC6MXqLpseUAQC5Bx3r5mgn"},{"privKey":"5ad44ed4cddddf32cb94e520d6d2e5c8eca07e1f57870f2ffb76a401ab858706","compressedPubKey":"02940735e7f3b42b9a38d9c94eb260b82769e6d63e35063b7618446d7b75c30076","compressedAddr":"1z6kJwEpj1mAT8kYhWh7E3UarNtNpj7Qx","unCompressedPubKey":"04940735e7f3b42b9a38d9c94eb260b82769e6d63e35063b7618446d7b75c30076141cbddb1b1805b2bef9a4cc6c7a68a8cea976e22cad03ef61206f8fa216881a","unCompressedAddr":"17CuKaNdAHHkFnYv3U7k3brbvnd4QZDEzU"},{"privKey":"2b09c2c1c979b293a5ad68f18dfc14ec5dd2037a863a9190b164d1d770ec067e","compressedPubKey":"02d1318af2099511e67ede4fc7501bc6a7d85ec1dab2deee8e54130bc91b0c9f4c","compressedAddr":"1BoyfuSUArnzJ2Gb3J3o6AharYeneYCFUP","unCompressedPubKey":"04d1318af2099511e67ede4fc7501bc6a7d85ec1dab2deee8e54130bc91b0c9f4c02b4461c15aa9734c639b9371c3dae97270e69745448bc984a7e037eda33db66","unCompressedAddr":"16RUUNqsQs9PUMpgoHUget5rWri6kLpeSD"},{"privKey":"4e4a8303db19568f1e11bda1502fbdfe1f504f2809924d3bda200cd62b53e0a1","compressedPubKey":"02bdbad3f0ca2c2f9977a12ae37b4c5d1ab66056a298d4289ea03596747ced94f1","compressedAddr":"12VNSiqV7o7KwM6vt9Fk2X8ccXcJcscx9r","unCompressedPubKey":"04bdbad3f0ca2c2f9977a12ae37b4c5d1ab66056a298d4289ea03596747ced94f174fc37544e1629e501ac38f1878e51ea49e3b17b061cbf7dfcef978c5b8b2b8c","unCompressedAddr":"1GvWwUBuZNfFSYHupN8SJRv2HHBQdPNBZR"},{"privKey":"d90c71d9d18de8d91b7b38025515737a0e91018827eb683981eb0ffbb48f2077","compressedPubKey":"033c1bc811a30e79ee832d4a26327b66af31f7da43e09e52ee3a7c849d9e611f91","compressedAddr":"1PXhwVAAhzy3skHBxByCEDvSUpwpWoKjeq","unCompressedPubKey":"043c1bc811a30e79ee832d4a26327b66af31f7da43e09e52ee3a7c849d9e611f91ac1d7f0a272b4b1a70bb39b16a0345a4b4e9551c0806ad14f063fb3c768d63ab","unCompressedAddr":"1BqwXpYgeZBcKtMc4vtE7hz5rGKuVq14BQ"},{"privKey":"5eb4c1e2cede127dd6ad8515a2f282ad327643542c0cd72f7214b89a8e21ca07","compressedPubKey":"033f7cf5c0eaecdcbd5831fb5c99be3936af4837c3318a93cb1332f9e65461f02b","compressedAddr":"1DTcWKNKkfHNY2Zj2vhL1U6HRrateuL16S","unCompressedPubKey":"043f7cf5c0eaecdcbd5831fb5c99be3936af4837c3318a93cb1332f9e65461f02bf8cd83a8347f2cf2507968b08a380fa95f57aa1ffecbdf82a105fe0b680d09eb","unCompressedAddr":"1JiSxHN879rwLTdJG8qrMZJmLbhuvM8Hzw"},{"privKey":"4e5cdf5cc066f23b827665bf70a1e2f64b27e165187ca68a14083cfcf307ea0d","compressedPubKey":"03cb8fa7489399b2fa29cf8a391ba6d328be93e6deb33cde0dbc61c139693e5399","compressedAddr":"14pA6pRu9m4V74tzaJL7nunz42vAJx9rWw","unCompressedPubKey":"04cb8fa7489399b2fa29cf8a391ba6d328be93e6deb33cde0dbc61c139693e539999dba29d56b22f673d64ec3f292301faf7e1ced52f98b579ed7fc6b81ee41aa7","unCompressedAddr":"18rXq7YDTAxGTnDyoaNPTD6JMdub87YvRq"},{"privKey":"fec37c8abac87bd51c463a31c036c4ca5781d91304ddae9ade6af1640dc74d9d","compressedPubKey":"027f611f950e0eb07bcc8e51e0e8f40ceac5ee839a42c80127e34008c71be1bad3","compressedAddr":"127Bm6LJjudaJqbKkjshCbo7D7WSAW9Q8Y","unCompressedPubKey":"047f611f950e0eb07bcc8e51e0e8f40ceac5ee839a42c80127e34008c71be1bad3106483df466bc5ad7430fc3510397c9154cb968ec84b66fd811e6744ceebcc9e","unCompressedAddr":"13RY47AZbB2iWWYhwywARDeumBQAnzA64n"},{"privKey":"32b7c93d33a4756cb0c417e80fcbfd99d87b9755e5dc0748368ceef2149ecd4b","compressedPubKey":"03f2bfc15191eea204244eed6584a7ee9213e0483e15bba90d27f856ea2af23a08","compressedAddr":"13MJk8bF22PMos8pcoN4neoaMHiRGcRe5D","unCompressedPubKey":"04f2bfc15191eea204244eed6584a7ee9213e0483e15bba90d27f856ea2af23a089914e4b87023aca6dfc17e60cf798c40d57024ccf10d4411e8190787c8c1d681","unCompressedAddr":"1LCrMv26mungrKpjxrPBqB68YvSXWYNhkS"},{"privKey":"5433bbbca4562751981c394cda55be4d771d906dbfcc26ba7b12fed1bb887806","compressedPubKey":"03178d1d72b5e325c52d41ae625e1ed82a5c7cdb089682fb9f3f448d7dd5db3e2d","compressedAddr":"1CAfWRKMeCUfBkwNaD2esD3tTaHaAUNhVU","unCompressedPubKey":"04178d1d72b5e325c52d41ae625e1ed82a5c7cdb089682fb9f3f448d7dd5db3e2db7c8bae4e00611f1d5d96eddc7a2ffa1e019184e9f58b94ad74b98d68f8b3225","unCompressedAddr":"1DxkZ9qoNN987fGsxE3K2y2KfMV5NWfEcG"},{"privKey":"283388e77d60580705cc57ba0709ff9fc19cd0605601db489dd7e4d084147e4a","compressedPubKey":"03d16a6935a6ba0f4b9f78316ace606c665663346b40c2e10f905760231b1ff456","compressedAddr":"14zPfL4Z5v5Gfqfdb1ZtBVXQ6EMKA9Vx7t","unCompressedPubKey":"04d16a6935a6ba0f4b9f78316ace606c665663346b40c2e10f905760231b1ff45667b753893d9fec81a8e51178c97a1984c0ae3014b121ac171f350fb08b4bf2d5","unCompressedAddr":"19qW9JDwv6jdbCXQixAA83LM3FNvr1Jegy"},{"privKey":"2925ea3453b05f0dca3ff82a5e2568838ba397fe42c0ae37a5f4e855f9005a21","compressedPubKey":"02d762e713d9ce7566e22e9b54709cee459f0b1b090ee1f752f80608f94a35742b","compressedAddr":"1A8gWPRKrFxK6JtLaLtBJukUVUYCrt9n5Z","unCompressedPubKey":"04d762e713d9ce7566e22e9b54709cee459f0b1b090ee1f752f80608f94a35742b42e70ffca626abe4702e9f55be967322df80ea88c44e8af73f07cf279f529020","unCompressedAddr":"14AYLd6VhWxubcvcWFRt2CkZLnJ2BXkg6v"},{"privKey":"63ab2f119678b934f463764ae816e28d135fd63d1b663213bcf4b5d3ed2ce87b","compressedPubKey":"03d88cf4eae4d978cc54c5f4cf6c8feabad066730d4693c38bd5f0425a77f7688e","compressedAddr":"1NJmJGBXt6hpCQoBn6LwcFjnjbazsDt7tT","unCompressedPubKey":"04d88cf4eae4d978cc54c5f4cf6c8feabad066730d4693c38bd5f0425a77f7688ec1896d327924dc161bee7297a54e0aa03b55f02a131b07b0561001e276891a39","unCompressedAddr":"17Po6THKg2meKyN6G9rQXvButRvLCTGhe1"},{"privKey":"d47f24dff60e80a14a62ae0c03c8c72406d7bcfa0418047c2918a35068a79285","compressedPubKey":"03caef6b270785d3dea3990ffd0eb90dcf435c371b64fb28d8a3309b13c76f9378","compressedAddr":"1EC8EEMmW9MR8Pny4D4rMGRtUf119JtgDq","unCompressedPubKey":"04caef6b270785d3dea3990ffd0eb90dcf435c371b64fb28d8a3309b13c76f9378cfae791e0db68bd6d647757cf97d2ddcf01293a47d7d25b7c655cd2e9810f4a1","unCompressedAddr":"1GeL7XXyTtM8TdMfJ76ojUf1Jw9dr7cC11"},{"privKey":"687aed7f8f1ef406a8f4325e8f622132ec2b18588936e99775bd0b6a5e595851","compressedPubKey":"03cc0da8645230b4bf9160a51de533222ea5bfa4c01598586c3ec06eaebe348694","compressedAddr":"13nc9faqU29qJKXuMc8GxYBu6teTd4X3vJ","unCompressedPubKey":"04cc0da8645230b4bf9160a51de533222ea5bfa4c01598586c3ec06eaebe3486941f3816c228709215bbe966897469c5399e0a8dfa5af576a222dba0caec6d7639","unCompressedAddr":"14agN8KCAKw2pGz8pi5uQ46tDZmkVeTaDU"},{"privKey":"aa6de3c7f4114a3b463c92b7bf3a8a04ee021e8cba7d8f641b02c7b95b40f2a3","compressedPubKey":"026e765685287835e5ffc1496887a79327671e94fbeeee0730680d0adcccc3ac07","compressedAddr":"16ra5Da5k8Q8VdUXBtjocR3jeN2mkHjoiw","unCompressedPubKey":"046e765685287835e5ffc1496887a79327671e94fbeeee0730680d0adcccc3ac071229ec5bf9e446c82f568bc6f80f84ea81238f58507d33cec5a725ba372d34b4","unCompressedAddr":"1AFiaVUSPcMsSHWVFZ1h29K9Rdqnijb6GS"},{"privKey":"24a6632b80314dbd4cd25431863f0932630cd189b807aa4b5f3ba9c2c46c8ff5","compressedPubKey":"029795a89106375952f8b4ced150e2c6fa487449e77f494d91f9286ff4a9b23b28","compressedAddr":"1Cw3CkrDFap57KeNc3aaRZYpgnuqhC9iUq","unCompressedPubKey":"049795a89106375952f8b4ced150e2c6fa487449e77f494d91f9286ff4a9b23b285f894fe6c2697daabc7b20f3215a2d0dce616f16e4bb7782c76f1a911c9144a0","unCompressedAddr":"1JXz5AWQX1swJGE7LpWXfd7T6MLduMuKZS"},{"privKey":"56b51ca4714132940c064e3360925abd3e5b07134b6916ad9ce1c423d776cd86","compressedPubKey":"02d65c36449c8a939865d7aefd0354f832c2a69d8fa76ac00808ccaa79c4f2edf2","compressedAddr":"1GAPHGFYkRh4Cd7es1vEh5ugpmKK3H2z4j","unCompressedPubKey":"04d65c36449c8a939865d7aefd0354f832c2a69d8fa76ac00808ccaa79c4f2edf2f1e42e8938da6c6ea7107d20267dbd0b53148e270dfbf6fcb6a6dd6708c1f8e8","unCompressedAddr":"1MmF8FVHNdbFpHPsXwVFUGjzQVP1UPAy49"},{"privKey":"c718249151925704630e006d15d95a0a74c96a161ede29b59301688601a8b99a","compressedPubKey":"033d9984b257ca9d60dacc3f7abaa0cab238257ca880cafefa5b5807043b8cf8a3","compressedAddr":"19rkua9gZuj43zJ5K2UkCpSA293hMTeSUN","unCompressedPubKey":"043d9984b257ca9d60dacc3f7abaa0cab238257ca880cafefa5b5807043b8cf8a3f0e9ef1690fe00ce4bde1c0bb26b339ecd1f539a3674782a4375dfb533ce46c9","unCompressedAddr":"1B9u5hNk6oCJrh43J3rEj8R7qcY961vANP"},{"privKey":"bc4a04616476dc6d0f7618f28afc6a5dc826b50b008e1a28f0cf8d7da20a03fd","compressedPubKey":"02f68a6088bdfb78f0b03d3452299e38bf017397625c614046e6023059e5968be4","compressedAddr":"13CY219DfESq33yqqRCg43Wxyx3DZ493er","unCompressedPubKey":"04f68a6088bdfb78f0b03d3452299e38bf017397625c614046e6023059e5968be43e01bc8f26bca2d163bf91b46255a7be72465d14b196125f4bf2714f7f8e35da","unCompressedAddr":"1riAFRRMndoziP4ebBpjk5CJFL5ZiQaoK"},{"privKey":"c3f964c9dfe0326893c27689a3efd6d5ed16c97c6733233a3c05d97f7735ecc8","compressedPubKey":"03187ec77ab34736c41256721d699c2d9171f2d0775d8d29069f6ce2526f7e1301","compressedAddr":"1pLHjtuYHMYQ25q24nZQMsBJ83Smv9FtN","unCompressedPubKey":"04187ec77ab34736c41256721d699c2d9171f2d0775d8d29069f6ce2526f7e1301c8500610535cbcdff5ce6abb6156b351c51e7d570461af6c866e81dfe99e7ed1","unCompressedAddr":"15Ex8HrrWjWnd3M2PtG5DfDraLNGEdBzDQ"},{"privKey":"a9aba33cfd5ce103f1f1c2e9fd2a1a2da89d8c8e8ccc14dc61a183e5b8ae4d5f","compressedPubKey":"033310378f7e97c57516e29b4310be8d12c87777aa16146673cccebdaa056b166d","compressedAddr":"1HPeMVRoVoBnYcuvQpabFRAbfMGTAaY6F2","unCompressedPubKey":"043310378f7e97c57516e29b4310be8d12c87777aa16146673cccebdaa056b166d19ba9018b91472919f2f11e027136905d303d3d00143dbd218487712a51fc56b","unCompressedAddr":"1DToG6m3YwRDDzR1cigHz1ufSnEtEw1N73"},{"privKey":"9b1a5b9b883a63ca2009db195512a167cfd22fb03d245ddc274764c7bd40e9d7","compressedPubKey":"02f43005792d123b69aced5c427fb51b50a1a1f84fd606516788c919fe0905f2d8","compressedAddr":"18MpojX7arsvUkehy3o9YPyVc1BrYggYHt","unCompressedPubKey":"04f43005792d123b69aced5c427fb51b50a1a1f84fd606516788c919fe0905f2d89e4e743ed0f0148a51952a56613283fecb9e7bc8c94782d14564113c1d25314a","unCompressedAddr":"13LFXKtFBsaN1GZQgH6Cz1AFuSFY47h4L3"},{"privKey":"7fb54c3be1a47ac6289f318a5a7fdff7746fae2ed2670215316128b564117f78","compressedPubKey":"03fe4a91642498fe5fa4b823a5e3ac026d0afc3bbfce839625bf344e0be74bd843","compressedAddr":"127tZcJgKsC1aP74G19BGPE6hLwBw2KbwP","unCompressedPubKey":"04fe4a91642498fe5fa4b823a5e3ac026d0afc3bbfce839625bf344e0be74bd843eaf37cb55b68aa772c781771eaa0692a6c0a7402589f6c772ce849051dd331cb","unCompressedAddr":"18139YQ93JeQy5aRQh14KxWgHEuUQEdQ8h"},{"privKey":"3fc856c8cbd36c793ec098f69014706180f51d6cf0f85fccb71cfc2e841a3199","compressedPubKey":"03daba156c4d2e34df26030393ca296b80e0252171d6d97a1a353f716b93e3b745","compressedAddr":"1Gj5uDmCUCNwmivnMYXqGDzSVf85i6DH4z","unCompressedPubKey":"04daba156c4d2e34df26030393ca296b80e0252171d6d97a1a353f716b93e3b7451419429bb5450332a3fd4b7e39c59d776ff985c0dab981df0306a55ca88ec427","unCompressedAddr":"1DvqwE1uY4ToFqwLe2dKv1ZRSv4Dr33G4Y"},{"privKey":"b08a295e99cabba83f514554eb9a8b7441478cd21654cd11bf352461700bc105","compressedPubKey":"03972e0d4f322d5420aeaeb9aaf5a7822359358bab9d67ef56dee9947aa71b1481","compressedAddr":"1N6pUe7YpLekYnM3BbmyQP2iuK3QkvEnk3","unCompressedPubKey":"04972e0d4f322d5420aeaeb9aaf5a7822359358bab9d67ef56dee9947aa71b1481cf70723cdea92293b1c69c2917ba760d7d18484a06ed35707f60deb90a33e11f","unCompressedAddr":"1D9QfHAPUg9Vuh7FmdRwEHfGS5u3LAzncm"},{"privKey":"913ef581e6f9e405a7ba351ccce328feca2a4b3d38ddf0fd602727e47d694f51","compressedPubKey":"031dc651b47c82afe7a88787e7d1177f938b34c6d6e229911d1512eaecf90589a7","compressedAddr":"1MCNqhcUvdvHkgmsqqyEdHBF4QCN1Ffc9N","unCompressedPubKey":"041dc651b47c82afe7a88787e7d1177f938b34c6d6e229911d1512eaecf90589a7de7a3c553781f4a0de6953297b6310e7b0aaa1f52ab9587e0df517d7dff62bb5","unCompressedAddr":"15CczniKYJmCXpNcmqYbRekEZ6AHngLp5C"},{"privKey":"eaa5ed533daae7706ca0ea31946a7305dcb5d4d36f41c32532ee6722eaf49ceb","compressedPubKey":"02a22acc4ce15249626a76bd845d6167858e1901cff103acc2b66e9fe36dc0df54","compressedAddr":"1MQACcV3jFacCrgexwuZehBcy4qmMZQ2df","unCompressedPubKey":"04a22acc4ce15249626a76bd845d6167858e1901cff103acc2b66e9fe36dc0df542857d3f721886bbe684afe5f03eda76ed2d154c0cc6b2a4fbfd74b4f38f07bee","unCompressedAddr":"1Bvbw4ttx4P8cikN5pQDuwpWMkJoszkudr"},{"privKey":"4e24e7f2c5a578e3ad9a4d984bef5d61c523f2d20850df261045a3f78064d2df","compressedPubKey":"03c39d02eedcf36ee9f61ec09868836fc2a84c77a88c7514acabfc296be71053b0","compressedAddr":"16VYiimAz6KwXw5f1mXs1KURdwo2MbXCL","unCompressedPubKey":"04c39d02eedcf36ee9f61ec09868836fc2a84c77a88c7514acabfc296be71053b0e748e593e3adbba245e7fd2520861888baa0aac8551aa781ae90a351b1c243e7","unCompressedAddr":"1DqGhprCJniUPXJaH2xDeLraXYaM1dM7zS"},{"privKey":"adea2a90cb49ff35e9502eb64717f9bec02d94f611eb4ce221033ad2b6111964","compressedPubKey":"02f5cd8c973e1d1544ec8e52a6d5f3bff932c2b6685f275f044b5aec31670b7825","compressedAddr":"1dsdRCdy6JeApknePi5Q7NYSbmsDLo5Hw","unCompressedPubKey":"04f5cd8c973e1d1544ec8e52a6d5f3bff932c2b6685f275f044b5aec31670b78253b4d8ec77755fbd14da9624d88a39e2588b020276325c1fa3adae98015cd668c","unCompressedAddr":"16x2ooycmPGgnC59HicTMnsKmybM95xrEy"},{"privKey":"9a03eeb8d9fc042290833f4441c4ec78c193306a614ce11e7c153a3a73781668","compressedPubKey":"031ea5a65c28397cf3e816b378a0cb9334d6aff2bd1ff50846cf53a026b62ad179","compressedAddr":"12RqfhPVJT19ukDBm9ydwfYGg8hU6CNh6T","unCompressedPubKey":"041ea5a65c28397cf3e816b378a0cb9334d6aff2bd1ff50846cf53a026b62ad179698e6ade44b690a522e3816be9daae4ecbbfa11a6da848d89855783dbc998637","unCompressedAddr":"174D1xsquFsbmvDzKB4eQFNtGgsgdok1PA"},{"privKey":"76872285addb8978885f3912bee9ae0a084e6f53030234cb5de8726c916a08b1","compressedPubKey":"039879baeac70ec403ab7b78447636131429ce512d6557784f551d4cd88f168502","compressedAddr":"16gz8kMAna2yAnbFaeNRUBhRegRWfjpYLf","unCompressedPubKey":"049879baeac70ec403ab7b78447636131429ce512d6557784f551d4cd88f168502f3888bc51d59a929e7d48025d07a51b00129ceec8f43ca23219eca2e7565a58d","unCompressedAddr":"17JTfwkV3LBUKbUC7ZtxPxX4ANoC29dXja"},{"privKey":"c88949230c2f991c1d926c84548fe3d1db42412d477d2ff1ea001527cc46215d","compressedPubKey":"0398c233e5cac71d7bd384aa3e13c22c08fa4b6eaff3b23ef7b3f83cdd2883007f","compressedAddr":"1K24jEXtXkQ3TC5iEvaTyE6MzE6PnRAmTU","unCompressedPubKey":"0498c233e5cac71d7bd384aa3e13c22c08fa4b6eaff3b23ef7b3f83cdd2883007f49e7a8eac1d3878ef2a00039db35e0c391cf6302f844aed85291bc78082e8a0b","unCompressedAddr":"1FdtCxAUWwVZXQZqoZ6w5qvWuaNzhZvorB"},{"privKey":"ed2cb662edf0716b3ebfc6f5d5483048cdcb9773c2536d48c902e3a1f4faee39","compressedPubKey":"03b30b5299f61891cc40b7d8a625aa4ec4b86c0b0d09a4e7541878758dd8c23b51","compressedAddr":"14XFg4LxHFATDTQpsVgYgPsyR9XMNbh9TT","unCompressedPubKey":"04b30b5299f61891cc40b7d8a625aa4ec4b86c0b0d09a4e7541878758dd8c23b512276a8b79535ef538d832ee31076bc3ce1b9845a4e941633095b10f880077613","unCompressedAddr":"1LcqTmhUKLdtquEaGVf6BLVZWJdmxkhxf6"},{"privKey":"8037570f93857352ca193cf9badb1679826f37430a1f131ed723a774ef6a5fcf","compressedPubKey":"0395765980a930314e959d6a63eb25242c8e9788b9168513b8744b61726adf8ac9","compressedAddr":"1PFr1o6ow9Dbd1Zd49UfH5KFPVNqg7hua6","unCompressedPubKey":"0495765980a930314e959d6a63eb25242c8e9788b9168513b8744b61726adf8ac9e517d4007cd6b31ff6d10c00b87fe7175b056da19346e7032cdfb80118dce485","unCompressedAddr":"1FAEVjwtvLhbBpRHau46Htxed37C7YrSG6"},{"privKey":"65f24e043a9232427772503f2acfb807be98cf39399bf2718e8d3be5a7c4d775","compressedPubKey":"02a55dd5edcc1540e9da31a066f19450f3869affcc26a75dcf66a104502ce10f2e","compressedAddr":"1Fe4mYds8aN4noQwhTiiyj7SWJC2Bszm1U","unCompressedPubKey":"04a55dd5edcc1540e9da31a066f19450f3869affcc26a75dcf66a104502ce10f2e01fafc42c917b7b00e29d53ec8e8801771439b7b90e241d58be6b9f9e8cb11a8","unCompressedAddr":"1FGWuGhPoBYBZBdqiGkBZd5vMzBSpUxw12"},{"privKey":"e114f496e7311ca10a489b004c1841b4ebbc05742f98b46f3b3472a5f168136b","compressedPubKey":"03cdeffd9698683c6581d7ec3390a6451f8a27a1d3e3470a91cab7afe19c971a74","compressedAddr":"12K8dhqjAXsKzajh8UMh3XmLQzBZqHiUxh","unCompressedPubKey":"04cdeffd9698683c6581d7ec3390a6451f8a27a1d3e3470a91cab7afe19c971a747e50d603ac52bd6f538126746cc8739f887ecac42b00b0d157d57156801b848d","unCompressedAddr":"16QTzJLnt28sjjHcPauTg9yXVzXd5cB56k"},{"privKey":"5529b8aeba933f6a7a3e8e2a50d3e273a8e0a3ca5f8a89ce1182e7415345ee9a","compressedPubKey":"0223d57562c1b42a43b4bed1be74e730ed289f9cbd1fd2256dde225d37ce4f10b2","compressedAddr":"1P9neKTnEHnBPJ1nYrv7NhmMEyNScRBiCe","unCompressedPubKey":"0423d57562c1b42a43b4bed1be74e730ed289f9cbd1fd2256dde225d37ce4f10b268b8c649a421d4e3b39a68f8e5ae4f808178c65dc4571a1699cdca5d8acfa1ee","unCompressedAddr":"1HMEoURbGuGNQtXsS2yjZYg7szsvr8kaim"},{"privKey":"52d135872a25734ed3ddd122f3ea71d65073ace4f14a427743ca63885bcc8569","compressedPubKey":"02018c36679fcefa899a064a2dc8a0ab161d7b7f53244f61628a27196fe333f1b5","compressedAddr":"1ErjqpMhdcgC1cZE8BKxSvt7WNdvWqggNi","unCompressedPubKey":"04018c36679fcefa899a064a2dc8a0ab161d7b7f53244f61628a27196fe333f1b5b61f82e449f32f734f6a7f1cb295ec57cabb13998eb03f6b842c697bec3fec20","unCompressedAddr":"1DUajXE8QkS3fSCrW7qpHXZj4uTHjyVH4g"},{"privKey":"f45b81604a8a3f974c38d49bc4847e220e61d68174df18264b2d9593ecbb8cde","compressedPubKey":"03d1befc07b09cd819cd0a779486d22ab6af2ccf36fa0ab94bece162f3575c2aac","compressedAddr":"15LbdYvsn4t1wBNfA2Hi8Rmz1qQ9BHT434","unCompressedPubKey":"04d1befc07b09cd819cd0a779486d22ab6af2ccf36fa0ab94bece162f3575c2aac529e4c816c6a0835697b35da0f06f969ed90e894edcede2b18f7f25b72b4df7b","unCompressedAddr":"1EQmZ2z7LNLwN4KDb5Uhm2cUseu6Vo2jXd"},{"privKey":"da448dac62d9552ebad7ec28dbab1fd0c6dea58d45fab6d6ab0978928818f2ba","compressedPubKey":"027c671ef92258fdaea12b8a0ed29fcdd259c4461f9769016f52ae2e909d81dcab","compressedAddr":"1ELyFBjp1S68fFjVxtCHjgnYGoGxQZD5y6","unCompressedPubKey":"047c671ef92258fdaea12b8a0ed29fcdd259c4461f9769016f52ae2e909d81dcab31383db29240177c3a7dec7b76e8fcbb1551045ae00dcc6d440f6c8926f44c02","unCompressedAddr":"1F3oucV2jtE4ZpQrGq56d5x2KR9RgM4J6w"},{"privKey":"8d85a7a89cf6f58d1f72d40e75653314dd77cf0e280365cf89229acbc6e45279","compressedPubKey":"0322c1333fbee25ad8635ab4d87b3aec286d79f53d39d6b805dcf4eb563702482d","compressedAddr":"1HJFgi8CPynSCJZBPahrp77uwrkyxtjrWW","unCompressedPubKey":"0422c1333fbee25ad8635ab4d87b3aec286d79f53d39d6b805dcf4eb563702482dfdfddda7dab7ae792bd4df19dbfe2c8479d75d7caa6b4b3afbbe3afb76b128c1","unCompressedAddr":"1PvY5WRgydjTYdzV1LRbv4MzoHSG3W5Gi1"},{"privKey":"ed304bcc64f6a6db3bb6952d4945583e29f97732d51bafa3d6cd33663958aef8","compressedPubKey":"02dcc38cb0857337f07f4fd061840f36e9b5fac370795a5b456a3e7dba50c481f2","compressedAddr":"1Ko1KPH7Gt97ntRKMfaQdRDwMGFHJTtbHd","unCompressedPubKey":"04dcc38cb0857337f07f4fd061840f36e9b5fac370795a5b456a3e7dba50c481f2f61924384ca681e342a9722753b1eee557ccc5def08b84f02d7c0890ba9f69f0","unCompressedAddr":"18snVyksFGexcARAWRrbpTPUjPL2jfmmg8"},{"privKey":"da3c0f591b5c6f0f6c47bf7acc5c024bc9fdc481caa83025f1155413e759d6ff","compressedPubKey":"02013e232dad81cc8cb17242b3e62fee072a3445d9328389dcd4e41c1bd8e732ac","compressedAddr":"12hAvNiXWwE1oHf4aJrcjdLbcN4tHBQjNW","unCompressedPubKey":"04013e232dad81cc8cb17242b3e62fee072a3445d9328389dcd4e41c1bd8e732aca83e86b981310f02ba9308bbc6748d765f59059ae85ef10f9fdf5eab31c9c3f8","unCompressedAddr":"1KQdBbKsUrPCMvpuKFm7b4K789bwoD3AMs"},{"privKey":"c423c12a5ddcf45ace8e83961209a3c0bdc748f8bf0a02a3ea4a11fbf428022d","compressedPubKey":"033a3693ce07a85c87c4da914263d736029cb2536f163793795cf477371acf17bc","compressedAddr":"14pDAASU3fQ9RPjefpKjshrGPS4Dv3ExiR","unCompressedPubKey":"043a3693ce07a85c87c4da914263d736029cb2536f163793795cf477371acf17bcff743c7e189bfa1669eafd60fa6d13580659786af54930c495daae0e50e5f8fb","unCompressedAddr":"1H75eePjpjzFAmYXFwVKMb7A4n7qvWTftC"},{"privKey":"1435797e2fc7ffac0572b7a103d517ac077684b6a51876ab0b80ba109eb2c85c","compressedPubKey":"03f130736f7e758f595412e4f4cb5d4bd08e9245db6e4a8508ec3953f90d32dcfd","compressedAddr":"1Pvfe6KJzaZPrL8yweFPAiYA5c85zSUriV","unCompressedPubKey":"04f130736f7e758f595412e4f4cb5d4bd08e9245db6e4a8508ec3953f90d32dcfd2309cc12be5bc67d19f7730b464d6c521b859b35bce0166021f08612b784d859","unCompressedAddr":"1LpEQ98bCGefLFFDCVtRkWFL1UL9xfJgD8"},{"privKey":"d3a35c2132c80dedb5329476442ac5a7107f94abfac981debabdb596fc4e27ce","compressedPubKey":"034d5fc73b839c42f08f033162f44f93328732352756d3b2e976cdddebb3995e01","compressedAddr":"17DYTC2dJYHqGq772rpQwQpx2zgLc6uMFM","unCompressedPubKey":"044d5fc73b839c42f08f033162f44f93328732352756d3b2e976cdddebb3995e01a6768d2fb08a1f19129b92c89a4ab53a825bf6f1ab7723a744b060c5b9dd55cb","unCompressedAddr":"19YbtUE54tY8MrgywTvHhePixcGEuCR13s"},{"privKey":"dcd5206069ee6e48a9b65bf53e8e805575a7d3efc48f82f75b309c4dd8a598c9","compressedPubKey":"0318741fab05df20512ec939251a73b43c9bcdbc3443b0070272062d9b086726de","compressedAddr":"1CJcDWMN9qzfAEeJgKuxjA6o5e3wmC2f3W","unCompressedPubKey":"0418741fab05df20512ec939251a73b43c9bcdbc3443b0070272062d9b086726de004dd2774f293a74fd1abfc58d2a75ce16615c1f2b41d14d700c3477b0ec57e7","unCompressedAddr":"1GdFpkLmorNo3kjaLMydZ81veAUpgxVPMn"},{"privKey":"67be429abbaabbb710a72dad2e55dc4a1b10c68fbd75de4fb1cbb70d980c75a7","compressedPubKey":"0323d8d98ebc260b656907110d4702f92f7cb79098a382d6054af45c19575f18df","compressedAddr":"1FFzXN9udbZmwrjLv4svgDL6VXUuV9aTDL","unCompressedPubKey":"0423d8d98ebc260b656907110d4702f92f7cb79098a382d6054af45c19575f18dff8f1721ed573f2eea5ddd3f1969917ff2bab9bfb9362e2aa0fe5aef394d2d91b","unCompressedAddr":"1K2hVh7WmnmDVgaW1qpMuq67mvMeW55teZ"},{"privKey":"fe5d2e0754c7ca976d25653608eb0b5bdb2b51da2463707b465f3088f4f80aff","compressedPubKey":"024b1fa991d90b672dd77fb9af1eaea30866ffe3cc96185f673800ca538deac23f","compressedAddr":"1F7YM7cb7xrbcxkhBxXbjiAeim139q5UUx","unCompressedPubKey":"044b1fa991d90b672dd77fb9af1eaea30866ffe3cc96185f673800ca538deac23f7948db6d8db5185ce03ce310cac30b50a058a93cecc16028d7e6047c7411d3de","unCompressedAddr":"1JVYJWdKDvvDXb9RykQeuGUTrsnnvaYrDE"},{"privKey":"03a2dd922e5a2ac56bc8dff91b2f0b3c3fab12f8fd759d194a6b037a6e25d7e4","compressedPubKey":"030637e8f4974aa070604421075846c3591b15985b4648fe1dbca879a7b322319a","compressedAddr":"1NXtdgQk8VKHBGtDvatCqFAbrmx942kMVu","unCompressedPubKey":"040637e8f4974aa070604421075846c3591b15985b4648fe1dbca879a7b322319ada9b94c48f42b099422231d901212c03593084b87b1bec389e39cb0d7ae55d8f","unCompressedAddr":"1PMJddk3zNNJSgz2n5ZMt8WmyJ7BJKLTrQ"},{"privKey":"3ee8ce6bb72d9176168641a4a375b0f2119148807d5a9438b67180a7ed516a38","compressedPubKey":"020890b53c35ea5b4e8b1b5966385f01307426664be9250ed7b0dc2257777ae7b8","compressedAddr":"1GQh9caL74uKZXb226MQPQwSBNqg6YQsyS","unCompressedPubKey":"040890b53c35ea5b4e8b1b5966385f01307426664be9250ed7b0dc2257777ae7b8e6ce45e49edba8be3e30b65093c7a1035cfd6eaa6840cd93c3b2af5db2991c4e","unCompressedAddr":"12Dt1U5HNK2FF2da7JZpoebKSNSKPTTC2T"},{"privKey":"a911df5e6db48f66f93347ea3a5402585982a3bf35b1abe5280528bb82817f49","compressedPubKey":"02dcf52275bc563b9602be0c6cf149165d512f8c4f55fa3aa65e4423c67b638d60","compressedAddr":"1LoutC386ZCBQx26hcffAPJb9Yn2jujCEb","unCompressedPubKey":"04dcf52275bc563b9602be0c6cf149165d512f8c4f55fa3aa65e4423c67b638d6050a8079337dc55c8111c890aad3c5115f2e8197c62d4357b0e8e50180e2796c2","unCompressedAddr":"1MKoMf7aTdkotPGVtPchyCwUCFHLdYJYDx"},{"privKey":"b56367060231573f7ac3adcf44bca6656a9f5c80009ee9f097678488ef578d0a","compressedPubKey":"038d844d05f34cab273d7c56c2a3d6c554b071babffa30df19301d22355d5cc4a8","compressedAddr":"1PmteQ28y3wJfqjM11eL3D7AVdXcTiojHC","unCompressedPubKey":"048d844d05f34cab273d7c56c2a3d6c554b071babffa30df19301d22355d5cc4a863ff10369f9fbf716911297579bca95da9fa94bf978df7c26e7f75a338614a39","unCompressedAddr":"17tequbyh9mUfkaNEMRs9SZRjRyH5RjmBT"},{"privKey":"e44bff8c645d62e37e39bd693d58957847ce2c41ef1e860b9d64e25d0dbd32ba","compressedPubKey":"031138ff6be50dfcf8e8f4059f91865f54a023063ec9a1381c3b073ca3a24c02b9","compressedAddr":"1EoWit9bUoybLrCVeVRVP2NvzQ59KcR9zW","unCompressedPubKey":"041138ff6be50dfcf8e8f4059f91865f54a023063ec9a1381c3b073ca3a24c02b91fe66663a6e56f479b3d379f765648978b33a6ee2801268db6cf912a5e95387f","unCompressedAddr":"1HjdsdUhBD5PyLF6MMsiEnC8U84edZRfVZ"},{"privKey":"9187c8277ea4efbe6fe7b9d3c3ecd668ca3befa93220746849ae70e0105524ce","compressedPubKey":"024a7d2cf864f0c465fe736b3dd1ebe951d80900cd3587c5866833de84cf7728fa","compressedAddr":"1BkQJoNFPYck6a6yp693pPKcwjzXmD4DCN","unCompressedPubKey":"044a7d2cf864f0c465fe736b3dd1ebe951d80900cd3587c5866833de84cf7728fa31b2bd76092ad601a48ffa4dcb62e4b81c3f1754686b02d2d19caf16a3517eee","unCompressedAddr":"1HiKytCLNFeNzSpNvFhqcgCbqqHHPWtC4j"},{"privKey":"81e136d45f18c03897aaf39366be6f604393cd5263a3356691995098d915d46b","compressedPubKey":"03885281c638db7c7e0e613a6734d2db1c538101b49bdc5b2228572da3f782d4a9","compressedAddr":"1AjwuQMbgkRASAWvLgTcRD4Ycwmnk1Cis1","unCompressedPubKey":"04885281c638db7c7e0e613a6734d2db1c538101b49bdc5b2228572da3f782d4a96ff8a73908e2b61e0f76b8debf7d5799986c9369abd3468fc9d44b75d458e26f","unCompressedAddr":"17hZBAXc3hWJjsWTBcZcLGHsLKZg3DBLBd"},{"privKey":"97fe45d3875d7f1fcc2c79501f26f33e0b2d31e2ea8f82ed54a00a0fa7c8ee5b","compressedPubKey":"02cc0734a91df5720f1fd79c74954390b9dfc4834ef156a05ad9d2441e0664f2b1","compressedAddr":"13mPwvJY8vvMdB9RDh9Z7eMvVcYrE5SGBi","unCompressedPubKey":"04cc0734a91df5720f1fd79c74954390b9dfc4834ef156a05ad9d2441e0664f2b1f4c8352a0ee4ea60c8a3e3629659b53158b13917ce6920a99f785d78f22e05ce","unCompressedAddr":"1Q1qiLNRo9xxahd6zHvrTwaBL7UJVmjL18"},{"privKey":"a545e817d8951d5c2e96be41fb7ed00d938191dc8f2c2136cf3e5dfbe04f025e","compressedPubKey":"02455602db3f1b06983fd9606e127e0d6c12073c0d72ae63bcc9e7bb69afbb1f97","compressedAddr":"1CvNP3moGJKGWEY5UvDTeg6myt9HzssXRn","unCompressedPubKey":"04455602db3f1b06983fd9606e127e0d6c12073c0d72ae63bcc9e7bb69afbb1f97b49f71749b5019e535ede3f0a528718dab2456a3f65ede8e2296097977caceb0","unCompressedAddr":"1Lu2qfKMUJqLzd7T53cr4uqwKNygZ9hCtS"},{"privKey":"fb590472919c9906625f9ca7ac1e8de79b8b6e04b27b684c8b732f37b476b010","compressedPubKey":"0331d91951a7f0728f7a8038ae86e341e158de146657176d37ef4370a6e1a1b199","compressedAddr":"1FiRdtUZiBKP1ExZXEQ2MUEQtYcieGvVxS","unCompressedPubKey":"0431d91951a7f0728f7a8038ae86e341e158de146657176d37ef4370a6e1a1b19988f46aac1874711b33806be901711064da6daa05886956045afa39c86981511f","unCompressedAddr":"1JGP8AANPEfD5f7TNuRztH5CE8pk3uMN2w"},{"privKey":"083748dc519b47f67e54c42fcd801fb721a1b0943cbeeb9ff510610e47fcfecc","compressedPubKey":"03fe6a52e9fcb37cd401f71812a1097e929589bda6e5c06fc9e446fdbee55e7508","compressedAddr":"1DwmbRvyj7uzaNbBSPR4UvDLjoDB6fNUi3","unCompressedPubKey":"04fe6a52e9fcb37cd401f71812a1097e929589bda6e5c06fc9e446fdbee55e7508b97c78530b3795129689fafba96893cd6afaaed2175a82b575b5a766e6d2fbc9","unCompressedAddr":"1Q7K2kGXeepDNfJMcx4RvL8NUhkXvDjFF5"},{"privKey":"3760cac064413d956dfed17bbb3733a2caa09fd20069ba9cfe865a5bd2aaa50d","compressedPubKey":"031a50c7f1929d7fb2475c34f5ae2b7b01eef88cdd1df822f79f21ebd2540be6bb","compressedAddr":"1NudURJcTBFgHtQf1upaVbrbwwPccVDKEN","unCompressedPubKey":"041a50c7f1929d7fb2475c34f5ae2b7b01eef88cdd1df822f79f21ebd2540be6bb27c720fa818aa76155b0d894d2940119da13e027cde89ad2fe95a8b9b528d07f","unCompressedAddr":"1BkbcRjDjKmgMsc118CepwEmV6b796czgP"},{"privKey":"584bbc638e537f1d0d61d460cdbff01679567dbd3c1c364998de77a4ab60444f","compressedPubKey":"03f03dbb2e688cbc09c53002ce4ae73664cf694a770270d682f77aa3e87b60c6f1","compressedAddr":"1DEoB2hZzmU2i6YLRJXzkTfm3DvEFYA4wV","unCompressedPubKey":"04f03dbb2e688cbc09c53002ce4ae73664cf694a770270d682f77aa3e87b60c6f11b7ae0ec880d27531a67b1d0db092a88e0d8a0803495d9faad9b1b530f688cad","unCompressedAddr":"13z24juNx6ma4i28AUWTXZbgmxEyqt9uTS"},{"privKey":"7cb517c00c0eb282eb31171dfa1179090fd76190298bfc16f540318960abf35e","compressedPubKey":"039c7bb69cb65ee6fd66e1fafb5698dbfc1929b5c334c6c7a5c3e3878df5a447f5","compressedAddr":"178cWkyAhnA3Fd4Re1YbXtEaM9dHbzkR9Y","unCompressedPubKey":"049c7bb69cb65ee6fd66e1fafb5698dbfc1929b5c334c6c7a5c3e3878df5a447f57a4369bd267946ca5cb4ad739ed46a735abe22b91dce84e7b2ae142436fd6fbf","unCompressedAddr":"15oWgMy1QMTePnrsJhpWWzUEg79w25uqWy"},{"privKey":"b18e59ba4cf39ed92b69e28373b823bedae70104498ae0cc737a7a63e77c9d36","compressedPubKey":"02cbcc4adb5d7885a7c31d3cfc9e5920777bfe6ba466135b3878693111ef7095c5","compressedAddr":"1CMkLD1na1umjxgsJiLHScVrzEWaA3DaMX","unCompressedPubKey":"04cbcc4adb5d7885a7c31d3cfc9e5920777bfe6ba466135b3878693111ef7095c5a589f84147dce304fb6b9eeca41a3f28ba18574820e5ec87344357a3483f9c66","unCompressedAddr":"18mZVSXajM2M7aidHtAwA5NuLnZ5MPT8YZ"},{"privKey":"6449476fa4c44ac0e385abf81efda6798adc7b2012491e856e7180c3fcf9872a","compressedPubKey":"03888a1e4403e104f52f727c721dc59ce1506d133d39ce4731702ddf4301e5813a","compressedAddr":"15vMKGDgXC6t1x2gk7zLcmYeN3ndqwBZQj","unCompressedPubKey":"04888a1e4403e104f52f727c721dc59ce1506d133d39ce4731702ddf4301e5813aef2ac88bc20aca3cca47815cf108eeafb31a50865184e7c701204d91fda9cfc3","unCompressedAddr":"1B8vGUQKEyHbai494jKWKqLE861W5tioh2"},{"privKey":"74e8f38c04940018d6c473ef8d3bee3ca0dd146d6f5664f682e0349912d9cc22","compressedPubKey":"033e92f67eb53902c062b88613665693761c4474cc1430ecc8b57e0d56a36d0037","compressedAddr":"1LeJ5q67xQZgVwTDQx2rU4PL2FtpuViFrJ","unCompressedPubKey":"043e92f67eb53902c062b88613665693761c4474cc1430ecc8b57e0d56a36d00378aa81a0412b58b4c577e17075f7f64a70dc8209c2fee6ac018543b32c675fce7","unCompressedAddr":"1GEgLytg5qExXf78BrCc8J3tm7LfBvgbj8"},{"privKey":"4589e8f1c089a323eed9cee505f9ba13785836c6dd2c6a08f25b83a388ac6fc7","compressedPubKey":"02b16aa4ed7d992f1a8554bd1863145203f2e407b1b558d79587853cc5ef29eb65","compressedAddr":"141bY7z2WLCNtq3xu8ZTTMnmhY8CYM2E6w","unCompressedPubKey":"04b16aa4ed7d992f1a8554bd1863145203f2e407b1b558d79587853cc5ef29eb6536472a02ec78f4f4b279f1e527f9f55503aca11563416bf794a8e94c03c6edc4","unCompressedAddr":"1Ep38N3CihcQ2ezEw4oBJadUBSFwMnPVx8"},{"privKey":"2cb0e01ef535a535eeb075b53538670437549d575afbfbb2739a54a06824987f","compressedPubKey":"02faadda4e898ae50dc39633b6d92c886b41f6ae95a8b73addef6768788b01b7c9","compressedAddr":"1NQKAqBiEcS8TtUBiEiJncU3d7beeSg8K3","unCompressedPubKey":"04faadda4e898ae50dc39633b6d92c886b41f6ae95a8b73addef6768788b01b7c9a750c3c6e327db5ecd8277175302ec8bd63a7b28e94556789eb155815125eae8","unCompressedAddr":"137hhaQTYEV6sjxtTK1ur9dMFMnyx694Ks"},{"privKey":"45b0298606a3c7434d9da05cfa80cdf9cafbbac1b8bab3f63d9623f90a862065","compressedPubKey":"030947714b8ce3c446644171e09758e0a16bec0e821d7d70d30434e272481a076d","compressedAddr":"1DbHoUEeSFmY7SWkvGQtGbiVLoJ1YeqbYZ","unCompressedPubKey":"040947714b8ce3c446644171e09758e0a16bec0e821d7d70d30434e272481a076dc56ab173fdd530d5c2a05ad120c5dfb956faab7cf09e0233689a8975cce99fd3","unCompressedAddr":"1Mm31k54sNndC73PCAmdyVHcxuxYN1xSeh"},{"privKey":"d727cfdbf2c4d6db5a477fca6b1a7cc087996eb83a3dedcc5216c9a040e0992f","compressedPubKey":"025a588c72145dc8ce894da5c11d8df7430d61b2c4ab2e2452cad48f41a995cc4b","compressedAddr":"15NCVuR1qYx7JReEwDYsH33vH19WrCnSC7","unCompressedPubKey":"045a588c72145dc8ce894da5c11d8df7430d61b2c4ab2e2452cad48f41a995cc4b645c745087b7118d67e9b353e6213fbf5c4b8b295008bdd00a99b2fa6a1ab254","unCompressedAddr":"1KkbqNvYZMcsxqnnc5sAsuWumhUSxQKPq1"},{"privKey":"7a4acb34c0ce368017ef4d233def97e22d8c7e2589203ad4833de71c315ab54e","compressedPubKey":"0365dc5d6f2e570843975bab6d3af0826174112b29bfa7552d658c551964af64eb","compressedAddr":"1JFN2pAi4dLia79Uq5b47kcZuv98TLybVt","unCompressedPubKey":"0465dc5d6f2e570843975bab6d3af0826174112b29bfa7552d658c551964af64eb9fe39a529ff5c67744fdcc5918ab06d7269b7cd5b1aa0d77e69174568ebb3e2b","unCompressedAddr":"1MkaQHUXGvkAY9VfpBrRZY5xkh1W9abeho"},{"privKey":"b605b73d45ca3aefb24b242848fa12a608f7e294fd71b23ce19ab255c80d4e63","compressedPubKey":"029f9a16759df89849e99921d164ebc3780a6595a1a1e43b901aa1804b5473f77d","compressedAddr":"12gBW3unqf7qMwJP8HYyzDDDRyB5Fwi9qT","unCompressedPubKey":"049f9a16759df89849e99921d164ebc3780a6595a1a1e43b901aa1804b5473f77d56ef67259acd67e8ee45313195034559604f6fc0a665ae3edf4707e7ae7a23e6","unCompressedAddr":"1LT4cRZEcY2xJyRuLJynpS78HbUGDbSyCv"},{"privKey":"9c04737b2cca3a68ba12ce636b520f882789df6cd76e8d6604b525a133d7cf6e","compressedPubKey":"02a72ee083f2b017c1fa016aef90a88d22ec7e68eef004d349062829198a4eb5a9","compressedAddr":"14ryJ7xDn3obuMZPkg2avdo5dAMfKxkFK5","unCompressedPubKey":"04a72ee083f2b017c1fa016aef90a88d22ec7e68eef004d349062829198a4eb5a9a5b04cc40ac2097138e46f777cb27b73db251347362416d7f3f29bc3e57a71fa","unCompressedAddr":"1oVsVGwDbpy98MC7CjbeWYfVs7GWbR5sj"},{"privKey":"7418dfdd8e7679235388fb936f2ebbd39d053528f615e3548c8256fe6497b9b7","compressedPubKey":"02f76d4d61251edfbea3c822251f10580b6bb9719adf6d12d5609d1c743cb9e940","compressedAddr":"1JVQJ8QS9gbMxgCCY8zrMZWvfsBUDpA9hp","unCompressedPubKey":"04f76d4d61251edfbea3c822251f10580b6bb9719adf6d12d5609d1c743cb9e940b0f3a9781a5c8ccc99b0a84f826ef3bf14abccce8276a815de0e0a762ba5656e","unCompressedAddr":"1JgWevraKVd4MpkLteYUURUPLVyDa9361o"},{"privKey":"42d7122c004cea9ea8d1f8a92d9986609590f7cf99e8ab83a05a04a28261e401","compressedPubKey":"020dd08831cf6cdd4bc6d53a0dea782eedeae743ac2578dd8b0e5bbd1469399127","compressedAddr":"18JxkNsS3GCBpeapjPGuQTG63uCnBvNjKB","unCompressedPubKey":"040dd08831cf6cdd4bc6d53a0dea782eedeae743ac2578dd8b0e5bbd1469399127e2068494e76ca7528f77e1ae6425892536aa7ffd151e9ad68d9709f5a6aeb404","unCompressedAddr":"14CfY3fvwu8CZCqiMoK7w14Rr8Ddzkwzwa"},{"privKey":"b685f336c10e93af5ae7af10f2cbf635549b7bbc8c74fbc60ee67445b52355be","compressedPubKey":"0201b4d783279cb0da74593279c4f474417006b685173a479141e6087bdb71ea89","compressedAddr":"1Cwso1oaZTUQmqbq9j9qde1rUWGy22UazV","unCompressedPubKey":"0401b4d783279cb0da74593279c4f474417006b685173a479141e6087bdb71ea89a57a1f3cbf793184cf73232ede17a7f3ab722386f87a6af0984424d3fd405c66","unCompressedAddr":"1MRm2EAtTtiseWfGbqSDzWGyMgz4sE47Cx"},{"privKey":"b50ff647b1eec1c103f540621a6048c2b84ca92b8c8db9c46bffb1c53fab63ac","compressedPubKey":"03e376ea00a99dac4ee6ff410476fb34e2003028f516835feea6489674dd438c72","compressedAddr":"1rkaNw3QUJ6CD38VzBnEtKhY4ioL8hqiT","unCompressedPubKey":"04e376ea00a99dac4ee6ff410476fb34e2003028f516835feea6489674dd438c72f911814e00f830bb88683a14652b633720d949eb80e6fa4eabfe7388d1edb151","unCompressedAddr":"15P1V4UcWk5cvXK373eugEAr9vhD8EL6YK"},{"privKey":"0b30729670905c24f1d4d1a8c1b04ab8704d3b47fe6dcf02a521c9dd3bbf3812","compressedPubKey":"02df4898db5f2d722a20a90b5b36a636057fb719a73a8b8ff6df4c02063223910a","compressedAddr":"1KixW2UcU9JkPq1vGraBox5Q9XKWMmvHRC","unCompressedPubKey":"04df4898db5f2d722a20a90b5b36a636057fb719a73a8b8ff6df4c02063223910aa917dd19f0700ca1bea08fc75a7432a0bc63dc200b6ac358325b4398501f3020","unCompressedAddr":"14DYF263BQZibTV4CMxqxPvxMG68jqPP5b"},{"privKey":"6553f7822cff2adc3a731afe4ea5ea15108cc55a61327c66a606d73a49898cf2","compressedPubKey":"03bba1505e0d0c0f1ee82de3381386dcd20dcdb54353b4b37ace46a8896e53b557","compressedAddr":"1KvAagACE5QhdAr2kqj8TGhxaBjhk1Zeq","unCompressedPubKey":"04bba1505e0d0c0f1ee82de3381386dcd20dcdb54353b4b37ace46a8896e53b5573836041a859854e582f196f2ec7086187c719b6154baf0ccb0057163f0cbe821","unCompressedAddr":"1uSLDhrkNH6zBuJpwHixwoYi8VNfkV3mz"},{"privKey":"1d2c0304e6e336df2d60755fd71f2ea12122af36daf4186e2c2da0c57231652f","compressedPubKey":"022c5abff8ea09cefb820a0f1f97f4d79f62ae951ec060e2d67237a26b2d8faff6","compressedAddr":"18g9NFVEus9jfgz8xo3LEm14Z2cTgMqVg2","unCompressedPubKey":"042c5abff8ea09cefb820a0f1f97f4d79f62ae951ec060e2d67237a26b2d8faff60ad5ef63c58ca3ecc89b2000d19c46ffb35e0534b446403210fc1f42b39feae0","unCompressedAddr":"1Linjky5zkrerRYSJTzGi97k5aUua6QEUZ"},{"privKey":"94b71e6d626540a709850784c91a32f66a7493951367014bd95445361c953e46","compressedPubKey":"02ef135db1f42f3f7813c5e03d677743cffda8c1d00cb8f92d202af90d3e5f75d9","compressedAddr":"12pCYN5w5XpAAMPePFdDvupKadkY3A6fGL","unCompressedPubKey":"04ef135db1f42f3f7813c5e03d677743cffda8c1d00cb8f92d202af90d3e5f75d99771f44cb1353aa5000f3cf5c282b1b599da536d9f5f71bcb4a9564c684e820c","unCompressedAddr":"19KMh38iWtuNgJQk14YPgP91GAwySira8p"},{"privKey":"132187b2babcb4aceb4566c3cc98ad179b8a4216b1943be1c82283170deca6cb","compressedPubKey":"02243189c10e13a3e8207e55bb4e1eea36586accaf1075936a284466c7f7672dd0","compressedAddr":"1Fh1v8NDcEY7Uz9FA7B2s1jY6Jnyy6kqQM","unCompressedPubKey":"04243189c10e13a3e8207e55bb4e1eea36586accaf1075936a284466c7f7672dd0097a0e80a47cd165f20f0cb0615d4efba97d01faead374ab88aa7d49c32cab9a","unCompressedAddr":"15dkteScnfu6fBLpZ1xxzRjYpUSaCFg19s"},{"privKey":"92963fe7cdf4afe7f926675c15101ae4a8a1da160c460341f661e096be94c05d","compressedPubKey":"02bd03899e5d0dd5131fd3afe69eafbf282a4fc2d792ae59e0f6a05e932dba8e4a","compressedAddr":"1MFn5UffWPA7YAXSEWqpzzfThawHarLWmq","unCompressedPubKey":"04bd03899e5d0dd5131fd3afe69eafbf282a4fc2d792ae59e0f6a05e932dba8e4a70dcfe3ee8c3176993edffe481683f18beb0831a71c34292d34e3803f3579690","unCompressedAddr":"1FnN7NF9DdYUkg2oKDwxVqJ62jwjn4meJ5"},{"privKey":"d7ee63a8dafc0d60198abafe0e921156e0d99ae5d097111c3bfdb9750818ed8a","compressedPubKey":"0249572d555b08d4cb827361259f557f00eab099fda637db2203775ea9177e4697","compressedAddr":"143DgUv8EjkHj73vDj7PVf3qAappxTrBci","unCompressedPubKey":"0449572d555b08d4cb827361259f557f00eab099fda637db2203775ea9177e469750e062a47262eec12a877058eb627d1552d4e2f308b2bd017f2338b14932e1da","unCompressedAddr":"1HSgeNitBzbkMHdwRm69fjRtPtyyCB7FK9"},{"privKey":"0ca70f1e392c1d98f88c66c7f75f5b7722bdcb327defff1505312444090c1d0a","compressedPubKey":"028667e18991875b0784938e33006bc34253a3df2a0362f0db7be4ad9a02c43e2a","compressedAddr":"1AYDnU8UxdmLE6vVjChxcUA3qgfFNnhde","unCompressedPubKey":"048667e18991875b0784938e33006bc34253a3df2a0362f0db7be4ad9a02c43e2a3f1ccc371371419f97eea9b559ea39b59454f8c7c173e9547d7c3f2480840618","unCompressedAddr":"12N97KvC7irdrjBGWLPjv3W8vDnRRkMi4q"},{"privKey":"4a3cdc52892029266c71de0da1d5cd578131622e0aff435bc1622a14f7f0e421","compressedPubKey":"03047c87004435c413d992ac1f53da6c3e4f4587288e3fc4aa0f693d7082156d23","compressedAddr":"15ibQM2hX5Ss6J9dYUvdgFPvp6c2Yd2guz","unCompressedPubKey":"04047c87004435c413d992ac1f53da6c3e4f4587288e3fc4aa0f693d7082156d23a0a942c8e5985f2e3be73dea455bc3aba82cdfb3ebffd9d31f7b3c09fb635d6b","unCompressedAddr":"19F7U1zDsieQb2hAwrTM9rfCXTCfrU9XVz"}]';

    private function sxFallback() {
        return json_decode($this->expectedResultsJson);
    }

    /***
     *
     * This test checks the uncompressed public key, the compressed public key.
     * The uncompressed address, the compressed address.
     * @TODO check The WIF key.
     * Test validateAddress and validate WIF key functions
     *
     */
    public function testBlock()
    {
        $bitcoinECDSA = new BitcoinECDSA();

        $expectedRes = null;
        $sxPubKey = exec('echo -n "b7a5e63a5da3df5c04b5be15734733205a45b751259f46d89471d4a8cd120929" | sx pubkey');
        if($sxPubKey != '03a10b6eee47ad4382915d387ee7e17ed7bd22caa9771288df24560e7a5faad880')
        {
            echo "Warning SX is not installed. \n";
            $expectedRes = $this->sxFallback();
        }
        for($i = 0; $i<10; $i++)
        {

            if(!$expectedRes)
                $bitcoinECDSA->generateRandomPrivateKey();
            else
                $bitcoinECDSA->setPrivateKey($expectedRes[$i]->privKey);

            $privKey = $bitcoinECDSA->getPrivateKey();

            //test : compressed public key
            if(!$expectedRes)
                $sxPubKey = exec('echo -n "' . $privKey . '" | sx pubkey');
            else
                $sxPubKey = $expectedRes[$i]->compressedPubKey;

            $bpPubKey = $bitcoinECDSA->getPubKey();
            $this->assertEquals($bpPubKey, $sxPubKey, 'Something went wrong for privateKey : ' . $bitcoinECDSA->getPrivateKey() . ', please report us the issue');

            // test : compressed address
            $addr   = $bitcoinECDSA->getAddress();
            if(!$expectedRes)
                $sxAddr =  exec('echo -n "' . $privKey . '" | sx addr');
            else
                $sxAddr = $expectedRes[$i]->compressedAddr;

            $this->assertEquals($addr, $sxAddr, 'Something went wrong for privateKey : ' . $bitcoinECDSA->getPrivateKey() . ', please report us the issue');

            $this->assertTrue($bitcoinECDSA->validateAddress($addr), 'Something went wrong while validating address : ' . $addr . ' with private key : ' . $bitcoinECDSA->getPrivateKey() . ', please report us the issue');

            $this->assertTrue($bitcoinECDSA->validateWifKey($bitcoinECDSA->getWif()), 'Something went wrong while validating Wif key : ' . $bitcoinECDSA->getWif() . ' with private key : ' . $bitcoinECDSA->getPrivateKey() . ', please report us the issue');

            //test : uncompressed public key
            if(!$expectedRes)
                $ucSxPubKey = exec('echo -n "' . $privKey . '" | sx pubkey false');
            else
                $ucSxPubKey = $expectedRes[$i]->unCompressedPubKey;

            $bpUcPubKey = $bitcoinECDSA->getUncompressedPubKey();
            $this->assertEquals($bpUcPubKey, $ucSxPubKey, 'Something went wrong for privateKey : ' . $bitcoinECDSA->getPrivateKey() . ', please report us the issue');

            // test : uncompressed address
            if(!$expectedRes)
                $ucSxAddr = exec('echo -n "' . $privKey . '" | sx pubkey false | sx addr');
            else
                $ucSxAddr = $expectedRes[$i]->unCompressedAddr;
            $ucBpAddr = $bitcoinECDSA->getUncompressedAddress();
            $this->assertEquals($ucBpAddr, $ucSxAddr, 'Something went wrong for privateKey : ' . $bitcoinECDSA->getPrivateKey() . ', please report us the issue');

            $ucPt       = $bitcoinECDSA->getPubKeyPoints();
            $cDerPt     = $bitcoinECDSA->getPubKeyPointsWithDerPubKey($bpPubKey);
            $ucDerPt    = $bitcoinECDSA->getPubKeyPointsWithDerPubKey($bpUcPubKey);
            $this->assertEquals($ucPt['y'], $cDerPt['y'], 'decoding of compressed DER public key failed');
            $this->assertEquals($ucPt['y'], $ucDerPt['y'], 'decoding of uncompressed DER public key failed');

            // test : calculate Y with X (decompress compressed public key)

            $bitcoinECDSA->setPrivateKey('b7a5e63a5da3df5c04b5be15734733205a45b751259f46d89471d4a8cd120929');
            $bitcoinECDSA->generateRandomPrivateKey();
            $bitcoinECDSA->setPrivateKey('5d60f0259a57094daacf21dbe408f43176a2e00cc6057fad030d928df833755e');

            echo "\nprivate key : " . $bitcoinECDSA->getPrivateKey() . "\n";
            //$nonce = hash('sha256', rand(0,10000000) . microtime());
            //$nonce = '0910f9897f4e8524646d1e1caa53177d66dd5d8cfed01eabfb1b4b3810fb8f32';
            //echo "\nnonce : " . $nonce . "\n";

            $pts = $bitcoinECDSA->getSignatureHashPoints(hash('sha256', 'hello'));
            echo "Check pts signature \n";
            print_r($bitcoinECDSA->getPubKey());
            print_r($bitcoinECDSA->checkSignaturePoints($bitcoinECDSA->getPubKey(), $pts['R'], $pts['S'], hash('sha256', 'hello')));
            echo "\nEND";
            $signedMessage = $bitcoinECDSA->signMessage('Hello ' . $i);
            echo $signedMessage."\n";
            echo "\nSignature:\n";
            print_r($bitcoinECDSA->getSignatureHashPoints(hash('sha256', rand(0,10000000))));
            // test : signed message is valid
            $this->assertTrue($bitcoinECDSA->checkSignatureForRawMessage($signedMessage));



            echo $signedMessage;
            // test : DER signature
            $hash = hash('sha256', rand(0,10000000) . microtime());
            $signature = $bitcoinECDSA->signHash($hash);

            $this->assertTrue($bitcoinECDSA->checkDerSignature($bitcoinECDSA->getPubKey(), $signature, $hash));

        }
    }

    public function testVerifySignedMessages()
    {
        $bitcoinECDSA = new BitcoinECDSA();

        $this->assertTrue($bitcoinECDSA->checkSignatureForRawMessage("-----BEGIN BITCOIN SIGNED MESSAGE-----
This is an example of a signed message.
-----BEGIN SIGNATURE-----
1HZwkjkeaoZfTSaJxDw6aKkxp45agDiEzN
G+ckNQLD26XRplYry7VqEoIS1O1U5c/qCrppiJjK8G2CtBIHZ+NDj9FLR/ojezD5Geyfv5sOSLWZAMO7y6YBmIs=
-----END BITCOIN SIGNED MESSAGE-----"));

        $this->assertTrue($bitcoinECDSA->checkSignatureForRawMessage("-----BEGIN BITCOIN SIGNED MESSAGE-----
oho
-----BEGIN SIGNATURE-----
1HZwkjkeaoZfTSaJxDw6aKkxp45agDiEzN
G9NVTo1N2vbNEVNYGgobMwwuZuUb0jWvytoRd92qfckoBjhlkTbDQehADRXOWWqHGexxWcPGmub0CPdcEC+0Rbs=
-----END BITCOIN SIGNED MESSAGE-----"));

        $this->assertTrue($bitcoinECDSA->checkSignatureForRawMessage("-----BEGIN BITCOIN SIGNED MESSAGE-----
aha
-----BEGIN SIGNATURE-----
1HZwkjkeaoZfTSaJxDw6aKkxp45agDiEzN
HJoQp4rhjY5wd4NyhSVUMy4EY+9npgOnXzro+l5ibkSBfA/p6JjkfUuvlnc8As6tw4eOIhtp2BN81xw/El9bpIg=
-----END BITCOIN SIGNED MESSAGE-----"));
    }
}
