<?php

/**
 * Abstract API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use Tatum\Sdk\Caller;
use Tatum\Sdk\HeaderSelector;
use Tatum\Sdk\Psr7\Exception\RequestException;
use Tatum\Sdk\Psr7\Request;
use Tatum\Sdk\Psr7\Http\Client;
use Tatum\Sdk\Serializer;
use Tatum\Sdk\ApiException;

abstract class AbstractApi {
    /**
     * Caller object
     *
     * @var \Tatum\Sdk\Caller
     */
    protected $_caller;

    /**
     * "Accept" and Content-Type header selector
     *
     * @var \Tatum\Sdk\HeaderSelector
     */
    protected $_headerSelector;

    /**
     * API Constructor
     *
     * @param Caller $caller API Caller object
     */
    public function __construct(Caller $caller) {
        $this->_caller = $caller;
        $this->_headerSelector = new HeaderSelector();
    }

    /**
     * Execute a request
     *
     * @param \Tatum\Sdk\Psr7\Request $request    An initialized request object.
     * @param string|null             $returnType (optional) Return type
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @return \Tatum\Model\ModelInterface|\Tatum\Sdk\Psr7\Http\ResponseInterface
     */
    protected function exec(Request $request, ?string $returnType = null) {
        // Prepare user agent info
        $userAgentExtra = [$request->getPackage()];

        // Debug mode
        if ($this->_caller->config()->getDebug()) {
            $userAgentExtra[] = "@DEBUG";
        }

        // Set the user-agent header
        $request->setHeader(
            "User-Agent",
            sprintf("%s (%s)", $this->_caller->config()->getUserAgent(), implode(", ", $userAgentExtra))
        );

        // Set the API key
        if (strlen($this->_caller->config()->getApiKey())) {
            $request->setHeader("x-api-key", $this->_caller->config()->getApiKey());
        }

        // Accept gzip compression
        $request->setHeader("Accept-Encoding", "gzip");

        try {
            $response = Client::send($request, $this->_caller->config());
        } catch (RequestException $exc) {
            $response = $exc->getResponse();

            throw (new ApiException(
                sprintf("[%d] Request error (%s): %s", (int) $exc->getCode(), $exc->getMessage(), $response->getBody()),
                (int) $exc->getCode(),
                $response->getHeaders(),
                $response->getBody()
            ))->setResponseObject(Serializer::deserialize($response->getBody(), "array"));
        }

        // Server error
        if ($response->getStatusCode() < 200 || $response->getStatusCode() > 299) {
            throw (new ApiException(
                sprintf("[%d] API error (%s)", $response->getStatusCode(), strval($request->getUri())),
                $response->getStatusCode(),
                $response->getHeaders(),
                $response->getBody()
            ))->setResponseObject(Serializer::deserialize($response->getBody(), "array"));
        }

        // Convert to a model
        return is_string($returnType) && strlen($returnType)
            ? Serializer::deserialize(
                $response->getBody(),
                $returnType,
                $response->getHeaders(),
                $this->_caller->config()
            )
            : $response;
    }
}
