<?php

/**
 * Implementation of BNBBeaconChain API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for BNBBeaconChain
 */
class BNBBeaconChainApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "BNB Beacon Chain";

    /**
     * Broadcast signed BNB transaction
     *
     * @param \Tatum\Model\Broadcast $broadcast 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionHash
     */
    public function bnbBroadcast($broadcast) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/bnb/broadcast";
        /** @var \Tatum\Model\TransactionHash $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $broadcast
            ), 
            "\Tatum\Model\TransactionHash"
        );
            
        return $result;
    }
    
    /**
     * Generate Binance wallet
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\BnbWallet
     */
    public function bnbGenerateWallet() {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/bnb/account";
        /** @var \Tatum\Model\BnbWallet $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", $rPath, $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\BnbWallet"
        );
            
        return $result;
    }
    
    /**
     * Get Binance Account
     *
     * @param string $address Account address you want to get balance of
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\BnbAccount
     */
    public function bnbGetAccount($address) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/bnb/account/{address}";
        /** @var \Tatum\Model\BnbAccount $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["address" => $address]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\BnbAccount"
        );
            
        return $result;
    }
    
    /**
     * Get Binance Transactions in Block
     *
     * @param float $height Block height
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\BnbBlock
     */
    public function bnbGetBlock($height) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/bnb/block/{height}";
        /** @var \Tatum\Model\BnbBlock $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["height" => $height]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\BnbBlock"
        );
            
        return $result;
    }
    
    /**
     * Get Binance current block
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return float
     */
    public function bnbGetCurrentBlock() {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/bnb/block/current";
        /** @var float $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", $rPath, $rPath, [], $rHeaders, []
            ), 
            "float"
        );
            
        return $result;
    }
    
    /**
     * Get Binance Transaction
     *
     * @param string $hash Transaction hash
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\BnbTx
     */
    public function bnbGetTransaction($hash) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/bnb/transaction/{hash}";
        /** @var \Tatum\Model\BnbTx $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["hash" => $hash]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\BnbTx"
        );
            
        return $result;
    }
    
    /**
     * Get Binance Transactions By Address
     *
     * @param string $address Account address
     * @param float $start_time Start time in milliseconds
     * @param float $end_time End time in milliseconds
     * @param float|null $limit Items per page.
     * @param float|null $offset Pagination offset
     * @param string|null $asset Asset name
     * @param string|null $address_type Address type
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\BnbTxInAccount
     */
    public function bnbGetTxByAccount($address, $start_time, $end_time, $limit = null, $offset = null, $asset = null, $address_type = null) {
        if ($start_time < 0) {
            throw new IAE('Invalid value for "$start_time" when calling BNBBeaconChainApi.bnbGetTxByAccount, must be bigger than or equal to 0.');
        }

        if ($end_time < 0) {
            throw new IAE('Invalid value for "$end_time" when calling BNBBeaconChainApi.bnbGetTxByAccount, must be bigger than or equal to 0.');
        }

        if (isset($limit) && $limit > 50) {
            throw new IAE('Invalid value for "$limit" when calling BNBBeaconChainApi.bnbGetTxByAccount, must be smaller than or equal to 50');
        }

        if (isset($limit) && $limit < 1) {
            throw new IAE('Invalid value for "$limit" when calling BNBBeaconChainApi.bnbGetTxByAccount, must be bigger than or equal to 1.');
        }

        if (isset($offset) && $offset < 0) {
            throw new IAE('Invalid value for "$offset" when calling BNBBeaconChainApi.bnbGetTxByAccount, must be bigger than or equal to 0.');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/bnb/account/transaction/{address}";
        /** @var \Tatum\Model\BnbTxInAccount $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["address" => $address]), $rPath, [
                    "startTime" => S::toQueryValue($start_time),
                    "endTime" => S::toQueryValue($end_time),
                    "limit" => isset($limit) ? S::toQueryValue($limit) : null,
                    "offset" => isset($offset) ? S::toQueryValue($offset) : null,
                    "asset" => isset($asset) ? S::toQueryValue($asset) : null,
                    "addressType" => isset($address_type) ? S::toQueryValue($address_type) : null,
                ], $rHeaders, []
            ), 
            "\Tatum\Model\BnbTxInAccount"
        );
            
        return $result;
    }
    
    /**
     * Send Binance / Binance Token from account to account
     *
     * @param \Tatum\Model\TransferBnbBlockchain $transfer_bnb_blockchain 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionHash
     */
    public function transferBnbBlockchain($transfer_bnb_blockchain) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/bnb/transaction";
        /** @var \Tatum\Model\TransactionHash $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_bnb_blockchain
            ), 
            "\Tatum\Model\TransactionHash"
        );
            
        return $result;
    }
    
    /**
     * Send Binance / Binance Token from account to account
     *
     * @param \Tatum\Model\TransferBnbBlockchainKMS $transfer_bnb_blockchain_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionHash
     */
    public function transferBnbBlockchainKMS($transfer_bnb_blockchain_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/bnb/transaction";
        /** @var \Tatum\Model\TransactionHash $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_bnb_blockchain_kms
            ), 
            "\Tatum\Model\TransactionHash"
        );
            
        return $result;
    }
    
}
