<?php

/**
 * Implementation of GasPump API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for GasPump
 */
class GasPumpApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Gas pump";

    /**
     * Activate gas pump addresses
     *
     * @param \Tatum\Model\ActivateGasPump $activate_gas_pump 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function activateGasPump($activate_gas_pump) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/gas-pump/activate";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $activate_gas_pump
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Activate gas pump addresses
     *
     * @param \Tatum\Model\ActivateGasPumpCelo $activate_gas_pump_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function activateGasPumpCelo($activate_gas_pump_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/gas-pump/activate";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $activate_gas_pump_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Activate gas pump addresses
     *
     * @param \Tatum\Model\ActivateGasPumpCeloKMS $activate_gas_pump_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function activateGasPumpCeloKMS($activate_gas_pump_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/gas-pump/activate";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $activate_gas_pump_celo_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Activate gas pump addresses
     *
     * @param \Tatum\Model\ActivateGasPumpKMS $activate_gas_pump_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function activateGasPumpKMS($activate_gas_pump_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/gas-pump/activate";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $activate_gas_pump_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Activate gas pump addresses
     *
     * @param \Tatum\Model\ActivateGasPumpTatum $activate_gas_pump_tatum 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function activateGasPumpTatum($activate_gas_pump_tatum) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/gas-pump/activate";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $activate_gas_pump_tatum
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Activate gas pump addresses
     *
     * @param \Tatum\Model\ActivateGasPumpTron $activate_gas_pump_tron 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function activateGasPumpTron($activate_gas_pump_tron) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/gas-pump/activate";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $activate_gas_pump_tron
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Activate gas pump addresses
     *
     * @param \Tatum\Model\ActivateGasPumpTronKMS $activate_gas_pump_tron_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function activateGasPumpTronKMS($activate_gas_pump_tron_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/gas-pump/activate";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $activate_gas_pump_tron_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Get the results of the address activation transaction
     *
     * @param string $chain The blockchain to work with
     * @param string $tx_id The ID of the address activation transaction
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\GasPumpTrxOut
     */
    public function activatedNotActivatedGasPumpAddresses($chain, $tx_id) {
        if (strlen($tx_id) > 80) {
            throw new IAE('Invalid length for "$tx_id" when calling GasPumpApi.activatedNotActivatedGasPumpAddresses, must be smaller than or equal to 80');
        }

        if (strlen($tx_id) < 10) {
            throw new IAE('Invalid length for "$tx_id" when calling GasPumpApi.activatedNotActivatedGasPumpAddresses, must be bigger than or equal to 10');
        }

        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/gas-pump/address/{chain}/{txId}";
        /** @var \Tatum\Model\GasPumpTrxOut $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "txId" => $tx_id]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\GasPumpTrxOut"
        );
            
        return $result;
    }
    
    /**
     * Approve the transfer of an asset from a gas pump address
     *
     * @param \Tatum\Model\ApproveTransferCustodialWallet $approve_transfer_custodial_wallet 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function approveTransferCustodialWallet($approve_transfer_custodial_wallet) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/approve";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $approve_transfer_custodial_wallet
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Approve the transfer of an asset from a gas pump address
     *
     * @param \Tatum\Model\ApproveTransferCustodialWalletCelo $approve_transfer_custodial_wallet_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function approveTransferCustodialWalletCelo($approve_transfer_custodial_wallet_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/approve";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $approve_transfer_custodial_wallet_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Approve the transfer of an asset from a gas pump address
     *
     * @param \Tatum\Model\ApproveTransferCustodialWalletCeloKMS $approve_transfer_custodial_wallet_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function approveTransferCustodialWalletCeloKMS($approve_transfer_custodial_wallet_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/approve";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $approve_transfer_custodial_wallet_celo_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Approve the transfer of an asset from a gas pump address
     *
     * @param \Tatum\Model\ApproveTransferCustodialWalletKMS $approve_transfer_custodial_wallet_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function approveTransferCustodialWalletKMS($approve_transfer_custodial_wallet_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/approve";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $approve_transfer_custodial_wallet_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Check whether the gas pump address with a specified index is activated
     *
     * @param string $chain The blockchain to work with
     * @param string $owner The blockchain address that owns the gas pump address to check; can be referred to as \&quot;master address\&quot;
     * @param float $index The index of the gas pump address to check
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Activated
     */
    public function gasPumpAddressesActivatedOrNot($chain, $owner, $index) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/gas-pump/activated/{chain}/{owner}/{index}";
        /** @var \Tatum\Model\Activated $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["chain" => $chain, "owner" => $owner, "index" => $index]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\Activated"
        );
            
        return $result;
    }
    
    /**
     * Precalculate gas pump addresses
     *
     * @param \Tatum\Model\CreateGasPump|null $create_gas_pump 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return string[]
     */
    public function precalculateGasPumpAddresses($create_gas_pump = null) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/gas-pump";
        /** @var string[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $create_gas_pump
            ), 
            "string[]"
        );
            
        return $result;
    }
    
    /**
     * Transfer an asset from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWallet $transfer_custodial_wallet 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWallet($transfer_custodial_wallet) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer multiple assets from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletBatch $transfer_custodial_wallet_batch 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletBatch($transfer_custodial_wallet_batch) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_batch
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer multiple assets from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletBatchCelo $transfer_custodial_wallet_batch_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletBatchCelo($transfer_custodial_wallet_batch_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_batch_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer multiple assets from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletBatchCeloKMS $transfer_custodial_wallet_batch_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletBatchCeloKMS($transfer_custodial_wallet_batch_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_batch_celo_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer multiple assets from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletBatchKMS $transfer_custodial_wallet_batch_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletBatchKMS($transfer_custodial_wallet_batch_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_batch_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer multiple assets from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletBatchTron $transfer_custodial_wallet_batch_tron 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletBatchTron($transfer_custodial_wallet_batch_tron) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_batch_tron
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer multiple assets from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletBatchTronKMS $transfer_custodial_wallet_batch_tron_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletBatchTronKMS($transfer_custodial_wallet_batch_tron_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer/batch";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_batch_tron_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer an asset from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletCelo $transfer_custodial_wallet_celo 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletCelo($transfer_custodial_wallet_celo) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_celo
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer an asset from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletCeloKMS $transfer_custodial_wallet_celo_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletCeloKMS($transfer_custodial_wallet_celo_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_celo_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer an asset from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletKMS $transfer_custodial_wallet_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletKMS($transfer_custodial_wallet_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer an asset from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletTron $transfer_custodial_wallet_tron 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletTron($transfer_custodial_wallet_tron) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_tron
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
    /**
     * Transfer an asset from a gas pump address
     *
     * @param \Tatum\Model\TransferCustodialWalletTronKMS $transfer_custodial_wallet_tron_kms 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\TransactionSigned
     */
    public function transferCustodialWalletTronKMS($transfer_custodial_wallet_tron_kms) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/blockchain/sc/custodial/transfer";
        /** @var \Tatum\Model\TransactionSigned $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $transfer_custodial_wallet_tron_kms
            ), 
            "\Tatum\Model\TransactionSigned"
        );
            
        return $result;
    }
    
}
