<?php

/**
 * Implementation of IPFS API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for IPFS
 */
class IPFSApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "IPFS";

    /**
     * Get file from IPFS
     *
     * @param string $id IPFS CID of the file
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \SplFileObject
     */
    public function getIPFSData($id) {
        $rHeaders = $this->_headerSelector->selectHeaders(["*", "application/json"], []);

        // Path template
        $rPath = "/v3/ipfs/{id}";
        /** @var \SplFileObject $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["id" => $id]), $rPath, [], $rHeaders, []
            ), 
            "\SplFileObject"
        );
            
        return $result;
    }
    
    /**
     * Store data to IPFS
     *
     * @param \SplFileObject|null $file Your file to store
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\StoreIPFS200Response
     */
    public function storeIPFS($file = null) {
        $rHeaders = $this->_headerSelector->selectHeadersForMultipart(["application/json"]);

        // Path template
        $rPath = "/v3/ipfs";
        /** @var \Tatum\Model\StoreIPFS200Response $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, ["file" => S::fileToFormValue($file),]
            ), 
            "\Tatum\Model\StoreIPFS200Response"
        );
            
        return $result;
    }
    
}
