<?php

/**
 * Implementation of OrderBook API
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Api;
!defined("TATUM-SDK") && exit();

use InvalidArgumentException as IAE;
use Tatum\Sdk\Serializer as S;

/**
 * API for OrderBook
 */
class OrderBookApi extends AbstractApi {
    
    /**
     * API package
     */
    const PKG = "Order Book";

    /**
     * Obtain chart data from historical closed trades
     *
     * @param \Tatum\Model\ChartRequest $chart_request 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Chart[]
     */
    public function chartRequest($chart_request) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/trade/chart";
        /** @var \Tatum\Model\Chart[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $chart_request
            ), 
            "\Tatum\Model\Chart[]"
        );
            
        return $result;
    }
    
    /**
     * Store buy / sell trade
     *
     * @param \Tatum\Model\CreateFutureTrade $create_future_trade 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Id
     */
    public function createFutureTrade($create_future_trade) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/trade";
        /** @var \Tatum\Model\Id $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $create_future_trade
            ), 
            "\Tatum\Model\Id"
        );
            
        return $result;
    }
    
    /**
     * Store buy / sell trade
     *
     * @param \Tatum\Model\CreateTrade $create_trade 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Id
     */
    public function createTrade($create_trade) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/trade";
        /** @var \Tatum\Model\Id $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $create_trade
            ), 
            "\Tatum\Model\Id"
        );
            
        return $result;
    }
    
    /**
     * Cancel all existing trades for account
     *
     * @param string $id Account ID
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return void
     */
    public function deleteAccountTrades($id) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/trade/account/{id}";
        $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "DELETE", S::parse($rPath, ["id" => $id]), $rPath, [], $rHeaders, []
            )
        );
    }
    
    /**
     * Cancel existing trade
     *
     * @param string $id Trade ID
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return void
     */
    public function deleteTrade($id) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/trade/{id}";
        $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "DELETE", S::parse($rPath, ["id" => $id]), $rPath, [], $rHeaders, []
            )
        );
    }
    
    /**
     * List all active buy trades
     *
     * @param \Tatum\Model\ListOderBookActiveBuyBody $list_oder_book_active_buy_body 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Trade[]
     */
    public function getBuyTradesBody($list_oder_book_active_buy_body) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/trade/buy";
        /** @var \Tatum\Model\Trade[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $list_oder_book_active_buy_body
            ), 
            "\Tatum\Model\Trade[]"
        );
            
        return $result;
    }
    
    /**
     * List all historical trades
     *
     * @param \Tatum\Model\ListOderBookHistoryBody|null $list_oder_book_history_body 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Trade[]
     */
    public function getHistoricalTradesBody($list_oder_book_history_body = null) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/trade/history";
        /** @var \Tatum\Model\Trade[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $list_oder_book_history_body
            ), 
            "\Tatum\Model\Trade[]"
        );
            
        return $result;
    }
    
    /**
     * List all matched orders from FUTURE_SELL/FUTURE_BUY trades
     *
     * @param \Tatum\Model\ListOderBookMatchedBody $list_oder_book_matched_body 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Trade[]
     */
    public function getMatchedTrades($list_oder_book_matched_body) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/trade/matched";
        /** @var \Tatum\Model\Trade[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $list_oder_book_matched_body
            ), 
            "\Tatum\Model\Trade[]"
        );
            
        return $result;
    }
    
    /**
     * List all active sell trades
     *
     * @param \Tatum\Model\ListOderBookActiveSellBody $list_oder_book_active_sell_body 
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Trade[]
     */
    public function getSellTradesBody($list_oder_book_active_sell_body) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], ["application/json"]);

        // Path template
        $rPath = "/v3/trade/sell";
        /** @var \Tatum\Model\Trade[] $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "POST", $rPath, $rPath, [], $rHeaders, [], $list_oder_book_active_sell_body
            ), 
            "\Tatum\Model\Trade[]"
        );
            
        return $result;
    }
    
    /**
     * Get existing trade
     *
     * @param string $id Trade ID
     * @throws \Tatum\Sdk\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * 
     * @return \Tatum\Model\Trade
     */
    public function getTradeById($id) {
        $rHeaders = $this->_headerSelector->selectHeaders(["application/json"], []);

        // Path template
        $rPath = "/v3/trade/{id}";
        /** @var \Tatum\Model\Trade $result */
        $result = $this->exec(
            S::createRequest(
                $this->_caller->config(), self::PKG, "GET", S::parse($rPath, ["id" => $id]), $rPath, [], $rHeaders, []
            ), 
            "\Tatum\Model\Trade"
        );
            
        return $result;
    }
    
}
