<?php

/**
 * BroadcastWithdrawal Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * BroadcastWithdrawal Model
 */
class BroadcastWithdrawal extends AbstractModel {

    public const _D = null;
    protected static $_name = "BroadcastWithdrawal";
    protected static $_definition = [
        "currency" => ["currency", "string", null, "getCurrency", "setCurrency", null, ["r" => 1, "nl" => 2, "xl" => 40]], 
        "tx_data" => ["txData", "string", null, "getTxData", "setTxData", null, ["r" => 1, "nl" => 1, "xl" => 500000]], 
        "withdrawal_id" => ["withdrawalId", "string", null, "getWithdrawalId", "setWithdrawalId", null, ["r" => 0, "nl" => 24, "xl" => 24]], 
        "signature_id" => ["signatureId", "string", 'uuid', "getSignatureId", "setSignatureId", null, ["r" => 0]]
    ];

    /**
     * BroadcastWithdrawal
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get currency
     *
     * @return string
     */
    public function getCurrency(): string {
        return $this->_data["currency"];
    }

    /**
     * Set currency
     * 
     * @param string $currency Currency of signed transaction to be broadcast, BTC, LTC, DOGE, BNB, XLM, TRX, BCH, ETH, XRP, ERC20, TRC20
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCurrency(string $currency) {
        return $this->_set("currency", $currency);
    }

    /**
     * Get tx_data
     *
     * @return string
     */
    public function getTxData(): string {
        return $this->_data["tx_data"];
    }

    /**
     * Set tx_data
     * 
     * @param string $tx_data Raw signed transaction to be published to network.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTxData(string $tx_data) {
        return $this->_set("tx_data", $tx_data);
    }

    /**
     * Get withdrawal_id
     *
     * @return string|null
     */
    public function getWithdrawalId(): ?string {
        return $this->_data["withdrawal_id"];
    }

    /**
     * Set withdrawal_id
     * 
     * @param string|null $withdrawal_id Withdrawal ID to be completed by transaction broadcast
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setWithdrawalId(?string $withdrawal_id) {
        return $this->_set("withdrawal_id", $withdrawal_id);
    }

    /**
     * Get signature_id
     *
     * @return string|null
     */
    public function getSignatureId(): ?string {
        return $this->_data["signature_id"];
    }

    /**
     * Set signature_id
     * 
     * @param string|null $signature_id ID of prepared payment template to sign. This is should be stored on a client side to retrieve ID of the blockchain transaction, when signing application signs the transaction and broadcasts it to the blockchain.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSignatureId(?string $signature_id) {
        return $this->_set("signature_id", $signature_id);
    }
}
