<?php

/**
 * EstimateFee Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * EstimateFee Model
 */
class EstimateFee extends AbstractModel {

    public const _D = null;
    public const CHAIN_CELO = 'CELO';
    public const CHAIN_ETH = 'ETH';
    public const CHAIN_BSC = 'BSC';
    public const CHAIN_XDC = 'XDC';
    public const CHAIN_ONE = 'ONE';
    public const CHAIN_MATIC = 'MATIC';
    public const CHAIN_KLAY = 'KLAY';
    public const TYPE_DEPLOY_ERC20 = 'DEPLOY_ERC20';
    public const TYPE_DEPLOY_NFT = 'DEPLOY_NFT';
    public const TYPE_MINT_NFT = 'MINT_NFT';
    public const TYPE_BURN_NFT = 'BURN_NFT';
    public const TYPE_TRANSFER_NFT = 'TRANSFER_NFT';
    public const TYPE_TRANSFER_ERC20 = 'TRANSFER_ERC20';
    public const TYPE_DEPLOY_AUCTION = 'DEPLOY_AUCTION';
    public const TYPE_DEPLOY_MARKETPLACE = 'DEPLOY_MARKETPLACE';
    protected static $_name = "EstimateFee";
    protected static $_definition = [
        "chain" => ["chain", "string", null, "getChain", "setChain", null, ["r" => 1, "e" => 1]], 
        "type" => ["type", "string", null, "getType", "setType", null, ["r" => 1, "e" => 1]], 
        "sender" => ["sender", "string", null, "getSender", "setSender", null, ["r" => 0, "nl" => 42, "xl" => 42]], 
        "recipient" => ["recipient", "string", null, "getRecipient", "setRecipient", null, ["r" => 0, "nl" => 42, "xl" => 42]], 
        "contract_address" => ["contractAddress", "string", null, "getContractAddress", "setContractAddress", null, ["r" => 0, "nl" => 42, "xl" => 42]], 
        "amount" => ["amount", "string", null, "getAmount", "setAmount", null, ["r" => 0, "p" => "/^[+]?((\\d+(\\.\\d*)?)|(\\.\\d+))$/"]]
    ];

    /**
     * EstimateFee
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }

    /**
     * Get allowable values
     *
     * @return string[]
     */
    public function getChainAllowableValues(): array {
        return [
            self::CHAIN_CELO,
            self::CHAIN_ETH,
            self::CHAIN_BSC,
            self::CHAIN_XDC,
            self::CHAIN_ONE,
            self::CHAIN_MATIC,
            self::CHAIN_KLAY,
        ];
    }
    /**
     * Get allowable values
     *
     * @return string[]
     */
    public function getTypeAllowableValues(): array {
        return [
            self::TYPE_DEPLOY_ERC20,
            self::TYPE_DEPLOY_NFT,
            self::TYPE_MINT_NFT,
            self::TYPE_BURN_NFT,
            self::TYPE_TRANSFER_NFT,
            self::TYPE_TRANSFER_ERC20,
            self::TYPE_DEPLOY_AUCTION,
            self::TYPE_DEPLOY_MARKETPLACE,
        ];
    }

    /**
     * Get chain
     *
     * @return string
     */
    public function getChain(): string {
        return $this->_data["chain"];
    }

    /**
     * Set chain
     * 
     * @param string $chain The blockchain to estimate the fee for
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setChain(string $chain) {
        return $this->_set("chain", $chain);
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType(): string {
        return $this->_data["type"];
    }

    /**
     * Set type
     * 
     * @param string $type The type of the transaction
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setType(string $type) {
        return $this->_set("type", $type);
    }

    /**
     * Get sender
     *
     * @return string|null
     */
    public function getSender(): ?string {
        return $this->_data["sender"];
    }

    /**
     * Set sender
     * 
     * @param string|null $sender (Only if <code>type=TRANSFER_ERC20</code>) The blockchain address of the sender address
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSender(?string $sender) {
        return $this->_set("sender", $sender);
    }

    /**
     * Get recipient
     *
     * @return string|null
     */
    public function getRecipient(): ?string {
        return $this->_data["recipient"];
    }

    /**
     * Set recipient
     * 
     * @param string|null $recipient (Only if <code>type=TRANSFER_ERC20</code>) The blockchain address of the recipient address
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setRecipient(?string $recipient) {
        return $this->_set("recipient", $recipient);
    }

    /**
     * Get contract_address
     *
     * @return string|null
     */
    public function getContractAddress(): ?string {
        return $this->_data["contract_address"];
    }

    /**
     * Set contract_address
     * 
     * @param string|null $contract_address (Only if <code>type=TRANSFER_ERC20</code>) The blockchain address of the smart address of the fungible token
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setContractAddress(?string $contract_address) {
        return $this->_set("contract_address", $contract_address);
    }

    /**
     * Get amount
     *
     * @return string|null
     */
    public function getAmount(): ?string {
        return $this->_data["amount"];
    }

    /**
     * Set amount
     * 
     * @param string|null $amount (Only if <code>type=TRANSFER_ERC20</code>) The amount of the fungible token to be sent
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAmount(?string $amount) {
        return $this->_set("amount", $amount);
    }
}
