<?php

/**
 * AccountBalance Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * AccountBalance Model
 */
class GenerateAccountAddress extends AbstractModel {

    public const _D = null;
    protected static $_name = "AccountAddress";
    protected static $_definition = [
        "generated_address" => ["address", "string", null, "getGeneratedAddress", "setGeneratedAddress", null, ["r" => 1]],
        "currency" => ["currency", "string", null, "getAddressCurrency", "setAddressCurrency", null, ["r" => 1]],
        "derivation_key" => ["derivationKey", "string", null, "getDerivationKey", "setDerivationKey", null, ["r" => 1]],
        "destination_tag" => ["destinationTag", "string", null, "getDestinationTag", "setDestinationTag", null, ["r" => 1]],
        "memo" => ["memo", "string", null, "getMemo", "setMemo", null, ["r" => 1]],
        "message" => ["message", "string", null, "getMessage", "setMessage", null, ["r" => 1]],
        "xpub" => ["xpub", "string", null, "getXpub", "setXpub", null, ["r" => 1]],
    ];

    /**
     * AccountBalance
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get generated_address
     *
     * @return string
     */
    public function getGeneratedAddress(): string {
        return $this->_data["generated_address"];
    }
    /**
     * Set generated_address
     *
     * @param string $generated_address All assets on the account, both available and blocked
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGeneratedAddress(string $generated_address) {
        return $this->_set("generated_address", $generated_address);
    }
  /**
     * Get currency
     *
     * @return string
     */
    public function getAddressCurrency(): string {
        return $this->_data["currency"];
    }
    /**
     * Set currency
     *
     * @param string $currency All assets on the account, both available and blocked
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAddressCurrency(string $currency) {
        return $this->_set("currency", $currency);
    }

    /**
     * Get derivation_key
     *
     * @return string
     */
    public function getDerivationKey(): string {
        return $this->_data["derivation_key"];
        //return $this->_data
    }
    /**
     * Set derivation_key
     *
     * @param string $derivation_key All assets on the account, both available and blocked
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDerivationKey(string $derivation_key) {
        return $this->_set("derivation_key", $derivation_key);
    }
 /**
     * Get destination_tag
     *
     * @return string
     */
    public function getDestinationTag(): string {
        return $this->_data["destination_tag"];
    }
    /**
     * Set derivation_key
     *
     * @param string $destination_tag All assets on the account, both available and blocked
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setDestinationTag(string $destination_tag) {
        return $this->_set("destination_tag", $destination_tag);
    }
 /**
     * Get memo
     *
     * @return string
     */
    public function getMemo(): string {
        return $this->_data["memo"];
    }
    /**
     * Set message
     *
     * @param string $memo All assets on the account, both available and blocked
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMemo(string $memo) {
        return $this->_set("message", $memo);
    }
    /**
     * Get message
     *
     * @return string
     */
    public function getMessage(): string {
        return $this->_data["message"];
    }
    /**
     * Set message
     *
     * @param string $message All assets on the account, both available and blocked
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setMessage(string $message) {
        return $this->_set("message", $message);
    }

    /**
     * Get xpub
     *
     * @return string
     */
    public function getXpub(): string {
        return $this->_data["xpub"];
    }
    /**
     * Set message
     *
     * @param string $xpub All assets on the account, both available and blocked
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setXpub(string $xpub) {
        return $this->_set("xpub", $xpub);
    }


}
