<?php

/**
 * NftRoyaltyErc721 Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * NftRoyaltyErc721 Model
 */
class NftRoyaltyErc721 extends AbstractModel {

    public const _D = null;
    protected static $_name = "NftRoyaltyErc721";
    protected static $_definition = [
        "addresses" => ["addresses", "string[]", null, "getAddresses", "setAddresses", null, ["r" => 0, "c" => 1]], 
        "values" => ["values", "string[]", null, "getValues", "setValues", null, ["r" => 0, "c" => 1]]
    ];

    /**
     * NftRoyaltyErc721
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get addresses
     *
     * @return string[]|null
     */
    public function getAddresses(): ?array {
        return $this->_data["addresses"];
    }

    /**
     * Set addresses
     * 
     * @param string[]|null $addresses The blockchain addresses where the royalty cashback will be sent every time the NFT is transferred
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAddresses(?array $addresses) {
        return $this->_set("addresses", $addresses);
    }

    /**
     * Get values
     *
     * @return string[]|null
     */
    public function getValues(): ?array {
        return $this->_data["values"];
    }

    /**
     * Set values
     * 
     * @param string[]|null $values The amounts of the royalties that will be paid to the authors of the NFT every time the NFT is transferred; the royalties are paid as a percentage of the NFT price (on Solana) or in a native blockchain currency (on the other supported blockchains)
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setValues(?array $values) {
        return $this->_set("values", $values);
    }
}
