<?php

/**
 * XdcTx Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * XdcTx Model
 */
class XdcTx extends AbstractModel {

    public const _D = null;
    protected static $_name = "XdcTx";
    protected static $_definition = [
        "hash" => ["hash", "string", null, "getHash", "setHash", null, ["r" => 0]], 
        "nonce" => ["nonce", "float", null, "getNonce", "setNonce", null, ["r" => 0]], 
        "block_hash" => ["blockHash", "string", null, "getBlockHash", "setBlockHash", null, ["r" => 0]], 
        "block_number" => ["blockNumber", "float", null, "getBlockNumber", "setBlockNumber", null, ["r" => 0]], 
        "transaction_index" => ["transactionIndex", "float", null, "getTransactionIndex", "setTransactionIndex", null, ["r" => 0]], 
        "from" => ["from", "string", null, "getFrom", "setFrom", null, ["r" => 0]], 
        "to" => ["to", "string", null, "getTo", "setTo", null, ["r" => 0]], 
        "value" => ["value", "string", null, "getValue", "setValue", null, ["r" => 0]], 
        "gas" => ["gas", "float", null, "getGas", "setGas", null, ["r" => 0]], 
        "gas_price" => ["gasPrice", "string", null, "getGasPrice", "setGasPrice", null, ["r" => 0]], 
        "input" => ["input", "string", null, "getInput", "setInput", null, ["r" => 0]], 
        "status" => ["status", "bool", null, "getStatus", "setStatus", null, ["r" => 0]], 
        "gas_used" => ["gasUsed", "float", null, "getGasUsed", "setGasUsed", null, ["r" => 0]], 
        "cumulative_gas_used" => ["cumulativeGasUsed", "float", null, "getCumulativeGasUsed", "setCumulativeGasUsed", null, ["r" => 0]], 
        "contract_address" => ["contractAddress", "string", null, "getContractAddress", "setContractAddress", null, ["r" => 0]], 
        "logs" => ["logs", "\Tatum\Model\KlaytnTxLogsInner[]", null, "getLogs", "setLogs", null, ["r" => 0, "c" => 1]], 
        "logs_bloom" => ["logsBloom", "string", 'DATA, 256 Bytes', "getLogsBloom", "setLogsBloom", null, ["r" => 0]], 
        "root" => ["root", "string", null, "getRoot", "setRoot", null, ["r" => 0]]
    ];

    /**
     * XdcTx
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get hash
     *
     * @return string|null
     */
    public function getHash(): ?string {
        return $this->_data["hash"];
    }

    /**
     * Set hash
     * 
     * @param string|null $hash Hash of the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setHash(?string $hash) {
        return $this->_set("hash", $hash);
    }

    /**
     * Get nonce
     *
     * @return float|null
     */
    public function getNonce(): ?float {
        return $this->_data["nonce"];
    }

    /**
     * Set nonce
     * 
     * @param float|null $nonce The number of transactions made by the sender prior to this one.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setNonce(?float $nonce) {
        return $this->_set("nonce", $nonce);
    }

    /**
     * Get block_hash
     *
     * @return string|null
     */
    public function getBlockHash(): ?string {
        return $this->_data["block_hash"];
    }

    /**
     * Set block_hash
     * 
     * @param string|null $block_hash Hash of the block where this transaction was in.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBlockHash(?string $block_hash) {
        return $this->_set("block_hash", $block_hash);
    }

    /**
     * Get block_number
     *
     * @return float|null
     */
    public function getBlockNumber(): ?float {
        return $this->_data["block_number"];
    }

    /**
     * Set block_number
     * 
     * @param float|null $block_number Block number where this transaction was in.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBlockNumber(?float $block_number) {
        return $this->_set("block_number", $block_number);
    }

    /**
     * Get transaction_index
     *
     * @return float|null
     */
    public function getTransactionIndex(): ?float {
        return $this->_data["transaction_index"];
    }

    /**
     * Set transaction_index
     * 
     * @param float|null $transaction_index Integer of the transactions index position in the block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTransactionIndex(?float $transaction_index) {
        return $this->_set("transaction_index", $transaction_index);
    }

    /**
     * Get from
     *
     * @return string|null
     */
    public function getFrom(): ?string {
        return $this->_data["from"];
    }

    /**
     * Set from
     * 
     * @param string|null $from Address of the sender.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFrom(?string $from) {
        return $this->_set("from", $from);
    }

    /**
     * Get to
     *
     * @return string|null
     */
    public function getTo(): ?string {
        return $this->_data["to"];
    }

    /**
     * Set to
     * 
     * @param string|null $to Address of the receiver. 'null' when its a contract creation transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setTo(?string $to) {
        return $this->_set("to", $to);
    }

    /**
     * Get value
     *
     * @return string|null
     */
    public function getValue(): ?string {
        return $this->_data["value"];
    }

    /**
     * Set value
     * 
     * @param string|null $value Value transferred in wei.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setValue(?string $value) {
        return $this->_set("value", $value);
    }

    /**
     * Get gas
     *
     * @return float|null
     */
    public function getGas(): ?float {
        return $this->_data["gas"];
    }

    /**
     * Set gas
     * 
     * @param float|null $gas Gas provided by the sender.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGas(?float $gas) {
        return $this->_set("gas", $gas);
    }

    /**
     * Get gas_price
     *
     * @return string|null
     */
    public function getGasPrice(): ?string {
        return $this->_data["gas_price"];
    }

    /**
     * Set gas_price
     * 
     * @param string|null $gas_price Gas price provided by the sender in wei.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGasPrice(?string $gas_price) {
        return $this->_set("gas_price", $gas_price);
    }

    /**
     * Get input
     *
     * @return string|null
     */
    public function getInput(): ?string {
        return $this->_data["input"];
    }

    /**
     * Set input
     * 
     * @param string|null $input The data sent along with the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setInput(?string $input) {
        return $this->_set("input", $input);
    }

    /**
     * Get status
     *
     * @return bool|null
     */
    public function getStatus(): ?bool {
        return $this->_data["status"];
    }

    /**
     * Set status
     * 
     * @param bool|null $status TRUE if the transaction was successful, FALSE, if the EVM reverted the transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setStatus(?bool $status) {
        return $this->_set("status", $status);
    }

    /**
     * Get gas_used
     *
     * @return float|null
     */
    public function getGasUsed(): ?float {
        return $this->_data["gas_used"];
    }

    /**
     * Set gas_used
     * 
     * @param float|null $gas_used The amount of gas used by this specific transaction alone.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setGasUsed(?float $gas_used) {
        return $this->_set("gas_used", $gas_used);
    }

    /**
     * Get cumulative_gas_used
     *
     * @return float|null
     */
    public function getCumulativeGasUsed(): ?float {
        return $this->_data["cumulative_gas_used"];
    }

    /**
     * Set cumulative_gas_used
     * 
     * @param float|null $cumulative_gas_used The total amount of gas used when this transaction was executed in the block.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setCumulativeGasUsed(?float $cumulative_gas_used) {
        return $this->_set("cumulative_gas_used", $cumulative_gas_used);
    }

    /**
     * Get contract_address
     *
     * @return string|null
     */
    public function getContractAddress(): ?string {
        return $this->_data["contract_address"];
    }

    /**
     * Set contract_address
     * 
     * @param string|null $contract_address The contract address created, if the transaction was a contract creation, otherwise null.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setContractAddress(?string $contract_address) {
        return $this->_set("contract_address", $contract_address);
    }

    /**
     * Get logs
     *
     * @return \Tatum\Model\KlaytnTxLogsInner[]|null
     */
    public function getLogs(): ?array {
        return $this->_data["logs"];
    }

    /**
     * Set logs
     * 
     * @param \Tatum\Model\KlaytnTxLogsInner[]|null $logs Log events, that happened in this transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLogs(?array $logs) {
        return $this->_set("logs", $logs);
    }

    /**
     * Get logs_bloom
     *
     * @return string|null
     */
    public function getLogsBloom(): ?string {
        return $this->_data["logs_bloom"];
    }

    /**
     * Set logs_bloom
     * 
     * @param string|null $logs_bloom Bloom filter for light clients to quickly retrieve related logs.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLogsBloom(?string $logs_bloom) {
        return $this->_set("logs_bloom", $logs_bloom);
    }

    /**
     * Get root
     *
     * @return string|null
     */
    public function getRoot(): ?string {
        return $this->_data["root"];
    }

    /**
     * Set root
     * 
     * @param string|null $root 32 bytes of post-transaction stateroot (pre Byzantium)
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setRoot(?string $root) {
        return $this->_set("root", $root);
    }
}
