<?php

/**
 * XlmAccount Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * XlmAccount Model
 */
class XlmAccount extends AbstractModel {

    public const _D = null;
    protected static $_name = "XlmAccount";
    protected static $_definition = [
        "id" => ["id", "string", null, "getId", "setId", null, ["r" => 0]], 
        "account_id" => ["account_id", "string", null, "getAccountId", "setAccountId", null, ["r" => 0]], 
        "sequence" => ["sequence", "string", null, "getSequence", "setSequence", null, ["r" => 0]], 
        "subentry_count" => ["subentry_count", "float", null, "getSubentryCount", "setSubentryCount", null, ["r" => 0]], 
        "last_modified_ledger" => ["last_modified_ledger", "float", null, "getLastModifiedLedger", "setLastModifiedLedger", null, ["r" => 0]], 
        "thresholds" => ["thresholds", "\Tatum\Model\XlmAccountThresholds", null, "getThresholds", "setThresholds", null, ["r" => 0]], 
        "flags" => ["flags", "\Tatum\Model\XlmAccountFlags", null, "getFlags", "setFlags", null, ["r" => 0]], 
        "balances" => ["balances", "\Tatum\Model\XlmAccountBalancesInner[]", null, "getBalances", "setBalances", null, ["r" => 0, "c" => 1]], 
        "signers" => ["signers", "\Tatum\Model\XlmAccountSignersInner[]", null, "getSigners", "setSigners", null, ["r" => 0, "c" => 1]], 
        "data" => ["data", "object", null, "getData", "setData", null, ["r" => 0]]
    ];

    /**
     * XlmAccount
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }


    /**
     * Get id
     *
     * @return string|null
     */
    public function getId(): ?string {
        return $this->_data["id"];
    }

    /**
     * Set id
     * 
     * @param string|null $id A unique identifier for this account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setId(?string $id) {
        return $this->_set("id", $id);
    }

    /**
     * Get account_id
     *
     * @return string|null
     */
    public function getAccountId(): ?string {
        return $this->_data["account_id"];
    }

    /**
     * Set account_id
     * 
     * @param string|null $account_id This account’s public key encoded in a base32 string representation.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setAccountId(?string $account_id) {
        return $this->_set("account_id", $account_id);
    }

    /**
     * Get sequence
     *
     * @return string|null
     */
    public function getSequence(): ?string {
        return $this->_data["sequence"];
    }

    /**
     * Set sequence
     * 
     * @param string|null $sequence This account’s current sequence number. For use when submitting this account’s next transaction.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSequence(?string $sequence) {
        return $this->_set("sequence", $sequence);
    }

    /**
     * Get subentry_count
     *
     * @return float|null
     */
    public function getSubentryCount(): ?float {
        return $this->_data["subentry_count"];
    }

    /**
     * Set subentry_count
     * 
     * @param float|null $subentry_count The number of subentries on this account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSubentryCount(?float $subentry_count) {
        return $this->_set("subentry_count", $subentry_count);
    }

    /**
     * Get last_modified_ledger
     *
     * @return float|null
     */
    public function getLastModifiedLedger(): ?float {
        return $this->_data["last_modified_ledger"];
    }

    /**
     * Set last_modified_ledger
     * 
     * @param float|null $last_modified_ledger The ID of the last ledger that included changes to this account.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setLastModifiedLedger(?float $last_modified_ledger) {
        return $this->_set("last_modified_ledger", $last_modified_ledger);
    }

    /**
     * Get thresholds
     *
     * @return \Tatum\Model\XlmAccountThresholds|null
     */
    public function getThresholds(): ?\Tatum\Model\XlmAccountThresholds {
        return $this->_data["thresholds"];
    }

    /**
     * Set thresholds
     * 
     * @param \Tatum\Model\XlmAccountThresholds|null $thresholds thresholds
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setThresholds(?\Tatum\Model\XlmAccountThresholds $thresholds) {
        return $this->_set("thresholds", $thresholds);
    }

    /**
     * Get flags
     *
     * @return \Tatum\Model\XlmAccountFlags|null
     */
    public function getFlags(): ?\Tatum\Model\XlmAccountFlags {
        return $this->_data["flags"];
    }

    /**
     * Set flags
     * 
     * @param \Tatum\Model\XlmAccountFlags|null $flags flags
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setFlags(?\Tatum\Model\XlmAccountFlags $flags) {
        return $this->_set("flags", $flags);
    }

    /**
     * Get balances
     *
     * @return \Tatum\Model\XlmAccountBalancesInner[]|null
     */
    public function getBalances(): ?array {
        return $this->_data["balances"];
    }

    /**
     * Set balances
     * 
     * @param \Tatum\Model\XlmAccountBalancesInner[]|null $balances The assets this account holds.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setBalances(?array $balances) {
        return $this->_set("balances", $balances);
    }

    /**
     * Get signers
     *
     * @return \Tatum\Model\XlmAccountSignersInner[]|null
     */
    public function getSigners(): ?array {
        return $this->_data["signers"];
    }

    /**
     * Set signers
     * 
     * @param \Tatum\Model\XlmAccountSignersInner[]|null $signers The public keys and associated weights that can be used to authorize transactions for this account. Used for multi-sig.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setSigners(?array $signers) {
        return $this->_set("signers", $signers);
    }

    /**
     * Get data
     *
     * @return object|null
     */
    public function getData(): ?object {
        return $this->_data["data"];
    }

    /**
     * Set data
     * 
     * @param object|null $data An array of account data fields.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setData(?object $data) {
        return $this->_set("data", $data);
    }
}
