<?php

/**
 * XlmAccount_signers_inner Model
 *
 * @copyright (c) 2022-2023 tatum.io
 * @license   MIT
 * @package   Tatum
 * @author    Mark Jivko
 * @link      https://tatum.io/
 *
 * NOTE: This class is auto-generated by tatum.io
 * Do not edit this file manually!
 */

namespace Tatum\Model;
!defined("TATUM-SDK") && exit();

/**
 * XlmAccount_signers_inner Model
 */
class XlmAccountSignersInner extends AbstractModel {

    public const _D = null;
    public const TYPE_SHA256_HASH = 'sha256_hash';
    public const TYPE_ED25519_PUBLIC_KEY = 'ed25519_public_key';
    public const TYPE_PREAUTH_TX = 'preauth_tx';
    protected static $_name = "XlmAccount_signers_inner";
    protected static $_definition = [
        "weight" => ["weight", "float", null, "getWeight", "setWeight", null, ["r" => 0]], 
        "key" => ["key", "string", null, "getKey", "setKey", null, ["r" => 0]], 
        "type" => ["type", "string", null, "getType", "setType", null, ["r" => 0, "e" => 1]]
    ];

    /**
     * XlmAccountSignersInner
     *
     * @param mixed[] $data Model data
     */
    public function __construct(array $data = []) {
        foreach(static::$_definition as $k => $v) {
            $this->_data[$k] = isset($data[$k]) ? $data[$k] : $v[5];
        }
    }

    /**
     * Get allowable values
     *
     * @return string[]
     */
    public function getTypeAllowableValues(): array {
        return [
            self::TYPE_SHA256_HASH,
            self::TYPE_ED25519_PUBLIC_KEY,
            self::TYPE_PREAUTH_TX,
        ];
    }

    /**
     * Get weight
     *
     * @return float|null
     */
    public function getWeight(): ?float {
        return $this->_data["weight"];
    }

    /**
     * Set weight
     * 
     * @param float|null $weight The numerical weight of a signer. Used to determine if a transaction meets the threshold requirements.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setWeight(?float $weight) {
        return $this->_set("weight", $weight);
    }

    /**
     * Get key
     *
     * @return string|null
     */
    public function getKey(): ?string {
        return $this->_data["key"];
    }

    /**
     * Set key
     * 
     * @param string|null $key A hash of characters dependent on the signer type.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setKey(?string $key) {
        return $this->_set("key", $key);
    }

    /**
     * Get type
     *
     * @return string|null
     */
    public function getType(): ?string {
        return $this->_data["type"];
    }

    /**
     * Set type
     * 
     * @param string|null $type The type of hash for this signer.
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setType(?string $type) {
        return $this->_set("type", $type);
    }
}
